# EvPaypal

## Notes

If using transaction items - paypal api requires quantity / unitPrice as well as description.
See EvCheckout for further example.

If tax is also present, set the unitPrice as exVat and pass taxAmount - again see EvCheckout for examples


## takePayment - extras array

### delivery

Delivery element for the extra array should contain the shipping address for the user.
This would be the return of EvAddressBook.Address::getAddress(ID)

### billing

billing element for the extra array should contain the billing address for the user.
This would be the return of EvAddressBook.Address::getAddress(ID)

### user

user element should contain the full user details of the user checking out. Using $Controller->Auth->user() is a good basis.

### description

description is used to override any transaction description message

### totals

totals should contain the extra totals information for a basket. Sub array should contain the following keys, the value would be the amount of that total

* subtotal
* tax
* delivery

## Config

The config is split between live and dev environments. Use the dev config for testing and put the live details in the live config.

### Limiting data sent to PayPal

The config has settings for limiting data that is sent to PayPal. By default all the totals and items are sent to PayPal. The following settings can be disabled to stop their data being sent to PayPal:
* `sendTotalsToPaypal` - The extra totals (subtotal, tax, shipping) can be removed so only the grand total is sent to PayPal.
* `sendItemListToPaypal` - The items can be stopped from being sent to PayPal.

## Troubleshooting
When creating a paypal app. If you need to select a sandbox account but there are none to select and there is an existing account:
* Create a new sandbox account, if that doesn't work:
* Make sure you are logged in on the account you are setting up the app for,
* Go to paypal developers and create a business account - https://www.sandbox.paypal.com/uk/webapps/mpp/account-selection
* In the sandbox accounts for the original paypal account, there is an option to link accounts. Use this and it should find your new account.
* Create the app using the new account.

If you are getting the error INVALID_EXPERIENCE_PROFILE_ID then go to the database of your site.
In the site settings there should be a row called "Payment Experience Id".
Set this to blank and it will generate a new id using the current paypal credentials.

If you are getting the following VALIDATION_ERROR error, check the items as there might be a rounding error caused due to PayPal calculating VAT differently to our code. If this is the case, disable sending items and totals to PayPal.

> Failed to get paypal approval link: VALIDATION_ERROR : Invalid request - see details :: transactions[0] : Item amount must add up to specified amount subtotal (or total if amount details not specified) //

## Paypal Onsite

This gateway uses a paypal overlay that approves the payment on the checkout page before submitting a form to be processed. The payment is not captured until takePayment is called in the server code. To use, first call the `PaypalOnsiteComponent::setClientToken()` when rendering the checkout page. This will add the necessary tokens to the view data. Then you can add the element to show the buttons:

``` php
<?= $this->Element('EvPaypal.paypal_include_script', [
	'currency' => CakeSession::read('EvCurrency.currencyCode'),
]); ?>
<?= $this->Element('EvPaypal.paypal_buttons', [
	'amount' => 3.35 // The total value of the order,
	'currency' => 'GBP' // The currency code,
	'checkoutFormSelector' => '#checkout-form' // The form selector to submit once the payment has been approved,
	'customerName' => 'Bob' // The name of the customer for the shipping address,
	'deliveryAddress' => [ // An address to use as the shipping address. This is the same format as an address from EvAddressBook.
		'Address' => [
			'address1' => 'Evoluted',
			'address2' => '35 Lambert Street',
			'city' => 'Sheffield',
			'county' => 'South Yorkshire',
			'post_code' => 'S3 7BH'
		],
		'Country' => [
			'iso2' => 'GB'
		],
	] //
]); ?>
```

When the form is posted the server must call `TransactionsComponent::takePayment()` with the usual data to capture and complete the payment. The difference here is that no card details are required and `$this->request->data['Paypal']` must be passed to `takePayment` in the `extras` array with the key `auth`;

At the time of writing the on site gateway doesn't respect all of the config options. The only options used are `clientId`, `clientSecret` and `brandName`.

To customise the JS button options (see paypal button docs) override the `EvPaypal.payment_script` element and create a `window.evPaypalButtonOptions` JS object.

### Hosted fields

As well as the standard buttons, this plugin supports using hosted fields. This is a form that appears on the site with some sensitive fields injected as iframes from paypal. This method requires JS is enabled. To use hosted fields, first update the paypal include url in the config to add `hosted-fields` to the components e.g.:

```php
'includeScript' => 'https://www.paypal.com/sdk/js?components=buttons,hosted-fields&intent=capture',
```

Then include the card fields on your form:

```php
<?= $this->Element('EvPaypal.paypal_advanced_card_fields', [
	'amount' => 3.35 // The total value of the order,
	'currency' => 'GBP' // The currency code,
	'checkoutFormSelector' => '#checkout-form' // The form selector to submit once the payment has been approved,
	'customerName' => 'Bob' // The name of the customer for the shipping address,
	'countries' => [
		'GB' => 'United Kingdom' // A list of countries with the iso2 codes as keys
		...
	],
	'deliveryAddress' => [ // An address to use as the shipping address. This is the same format as an address from EvAddressBook.
		'Address' => [
			'address1' => 'Evoluted',
			'address2' => '35 Lambert Street',
			'city' => 'Sheffield',
			'county' => 'South Yorkshire',
			'post_code' => 'S3 7BH'
		],
		'Country' => [
			'iso2' => 'GB'
		],
	]
	'formOptions' => [ // Options to be added when creating the form using Cake's helper
		'inputDefaults' => [
			'div' => 'form-group',
			'label' => [
				'class' => 'control-label'
			],
			'class' => 'form-control'
		],
	],
	'showOrDivider' => true, // Adds an "or pay by card" divider above the form if set
]);
?>
```

For some limited JS customisation options override the `EvPaypal.hosted_fields_script` element. To customise the form you can override the `EvPaypal.card_form`.

Styling is up to the hosting site so minimal styling has been applied in the plugin.

## Negative testing

Here are some useful links for testing different scenarios within Paypal.

- [Simulating card responses](https://developer.paypal.com/ppdevdocs/docs/platforms/test-go-live/simulation-tests-credit-debit/)
- [Simulating 3DS responses](https://developer.paypal.com/docs/business/checkout/3d-secure/3d-secure-test/)


# Paypal Checkout
In 2022 a new component was added for PayPal Checkout. This uses the Paypal Checkout Javascript SDK integration to provide an on-site payment form (via an iframe), that makes use of PayPal's built in 3D Secure / SCA checks.

To use this integration simply inject the component element into your payment page:

`<?=$this->element('EvPaypal.paypal_checkout', ['currency' => 'GBP']);?>`

Note that the currency variable can come from your controller. The following values are expected to exist:

- `$currency` - The currency code (uppercase)
- `$transactionData['Transaction']['transaction_amount']` - The transaction amount is taken from the transaction data, this should readily be available if using EvCheckout.
- `$transactionData['Transaction']['id']` - ID of the transaction
- `$hash` - See 'Payment Hash' below
- `$completeUrl` - the URL to redirect to. Note that you will be expected to handle converting the transaction to an order there, the same as with other payment gateways.
- `Configure::read('Paypal.id')` - The ID of the PayPal account. If you're migrating from the standard integration you'll already have this set. This is typically set in your `bootstra.php` file. See BrightonTools for an example of its implementation

## Payment Hash
Because we're using the Javascript SDK we have to provide a copy of the expected payment hash. This is a sha256 value consisting of the total, currency code andPaypal salt.

This should be set inside your controller/component where you're loading this page, and looks like this:

```php
$hashSalt = CakeSession::read('EvPaypal.hashSalt');
$hash = hash('sha256', $transactionData['Transaction']['transaction_amount'] . 'GBP' . $hashSalt);
$this->set('hash', $hash);
```

The `$hashSalt` is taken from your EvPaypal config file, and you should already have access to your `$transactionData` on this page.