<?php

App::uses('AppHelper', 'View/Helper');

class PaypalHelper extends AppHelper {

/**
 * Create an external link that directs the user to the recorded transaction in the gateway the
 * transaction was paid with.
 * @param  array $transaction The transaction to create the link from.
 * @return string             The url to the gateway to see the transaction.
 */
	public function buildGatewayTransactionUrl($transaction) {
		$paymentToken = json_decode($transaction['payment_token']);

		if (empty($paymentToken)) {
			return null;
		}

		if (!isset($paymentToken->TransactionId)) {
			return null;
		}

		if (Configure::read('app.environment') == 'PRODUCTION') {
			$url = 'https://www.paypal.com/activity/payment/';
		} else {
			$url = 'https://www.sandbox.paypal.com/activity/payment/';
		}

		$url .= $paymentToken->TransactionId;

		return $url;
	}
}
