<style>
    section {
        width: 100px;
        margin: 0 auto;
        padding: 20px;
    }

    .spinner {
        animation: rotate 1.4s linear infinite;
        -webkit-animation: rotate 1.4s linear infinite;
        -moz-animation: rotate 1.4s linear infinite;
        width:100px;
        height:100px;
        position: relative;
    }

    .spinner-dot {
        width:274px;
        height:274px;
        position: relative;
        top: 0;
    }


    @keyframes rotate {
        to {
            transform: rotate(360deg);
        }
    }

    @-webkit-keyframes rotate {
        to {
            -webkit-transform: rotate(360deg);
        }
    }

    @-moz-keyframes rotate {
        to {
            transform: rotate(360deg);
        }
    }

    .path {
        stroke-dasharray: 170;
        stroke-dashoffset: 20;
    }

</style>

<script src="https://www.paypal.com/sdk/js?client-id=<?=h(Configure::read('Paypal.id'))?>&currency=<?=$currency?>"></script>
<div id="paypal-button-container"></div>
<section id="loading" style="opacity: 0;">
    <svg class="spinner" width="100px" height="100px" viewBox="0 0 66 66" xmlns="http://www.w3.org/2000/svg">
        <circle class="path" fill="transparent" stroke-width="2" cx="33" cy="33" r="30" stroke="url(#gradient)"/>
        <linearGradient id="gradient">
            <stop offset="50%" stop-color="#000" stop-opacity="1"/>
            <stop offset="65%" stop-color="#000" stop-opacity=".5"/>
            <stop offset="100%" stop-color="#000" stop-opacity="0"/>
        </linearGradient>
        </circle>
        <svg class="spinner-dot dot" width="5px" height="5px" viewBox="0 0 66 66" xmlns="http://www.w3.org/2000/svg" x="37" y="1.5">
            <circle class="path" fill="#000" cx="33" cy="33" r="30"/>
            </circle>
        </svg>
    </svg>
</section>

<script>
    paypal.Buttons({
        createOrder: function(data, actions) {
            return actions.order.create({
                purchase_units: [{
                    amount: {
                        value: '<?=h($transactionData['Transaction']['transaction_amount'])?>'
                    }
                }]
            });
        },

        onApprove: function(data, actions) {
            return actions.order.capture().then(function(orderData) {
                $.ajax({
                    url: "/ajax/ev_paypal/paypal_checkout/create_order?transaction=<?=h($transactionData['Transaction']['id'])?>",
                    type: "POST",
                    dataType: "json",
                    data: {"order": orderData, "hash": '<?=$hash?>'},
                    success: function(){
                        // No nothing - the complete url handles the response
                    }
                });

                // Sleep for a few seconds to give the paypal server time to respond
                window.setTimeout(function() {
                    actions.redirect('<?=$completeUrl?>')
                }, 5000);

                var element = document.getElementById('paypal-button-container');
                element.style.opacity = "0";

                var loading = document.getElementById("loading");
                loading.style.opacity = "1";
            });
        }
    }).render('#paypal-button-container');

</script>
