<?php

App::uses('AppController', 'Controller');
App::uses('PaypalLib', 'EvPaypal.Lib');

class PaypalOnsiteController extends AppController {

	public $components = [
		'EvPaypal.PaypalOnsite'
	];

	public function beforeFilter()
	{
		$this->Auth->allow([
			'ajax_create_order'
		]);
		return parent::beforeFilter();
	}

	/**
	 * Creates an order from the current basket
	 *
	 * @return void
	 */
	public function ajax_create_order()
	{
		$this->autoRender = false;

		$orderData = $this->request->data['order'];
		$hash = $this->request->data['hash'];
		$amount = $orderData['purchase_units'][0]['amount']['value'];
		$currency = $orderData['purchase_units'][0]['amount']['currency_code'];

		if (!PaypalLib::checkHash($amount, $currency, $hash)) {
			throw new BadRequestException();
		};

		$this->PaypalOnsite->setup();

		try {
			$orderId = $this->PaypalOnsite->createOrder($orderData);
			return json_encode([
				'success' => true,
				'orderId' => $orderId
			]);
		} catch(Exception $e) {
			return json_encode([
				'success' => false,
				'error' => $e->getMessage()
			]);
		}
	}
}
