<?php

App::uses('AppController', 'Controller');
App::uses('PaypalLib', 'EvPaypal.Lib');

class PaypalCheckoutController extends AppController {

	public $components = [
		'EvPaypal.PaypalCheckout'
	];

/**
 * beforeFilter
 *
 * @return CakeResponse|void|null
 */
	public function beforeFilter() {
		$this->Auth->allow([
			'ajax_create_order'
		]);
		return parent::beforeFilter();
	}

/**
 * Processes the paypal checkout response and confirms the payment was successful
 *
 * @return false|string
 * @throws BadRequestException
 */
	public function ajax_create_order() {
		$this->autoRender = false;
		$transactionId = $this->request->query['transaction'];
		$orderData = $this->request->data['order'];

		$this->PaypalCheckout->setup();

		try {
			$orderId = $this->PaypalCheckout->createOrder($orderData);

			$paymentStatus = $this->PaypalCheckout->getPayment($transactionId, [
				'orderId' => $orderId,
			]);

			return json_encode([
				'success' => $paymentStatus['result'],
				'orderId' => $orderId
			]);
		} catch(Exception $e) {
			return json_encode([
				'success' => false,
				'error' => $e->getMessage()
			]);
		}
	}
}
