<?php
App::uses('PluginInstallShell', 'shells');

class EvPaypalInstallShell extends PluginInstallShell {

	public $uses = array(
		'EvSiteSettings.SiteSetting',
		'EvSiteSettings.SiteSettingCategory'
	);

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run() {
		parent::run();

		$Category = $this->SiteSettingCategory->save(
			array(
				'SiteSettingCategory' => array(
					'name' => 'PayPal Integration',
					'array_slug' => 'ev_paypal',
					'sequence' => 0,
					'prevent_edit' => 1
				)
			)
		);

		$this->SiteSetting->save(
			array(
				'SiteSetting' => array(
					'name' => 'Payment Experience Id',
					'array_slug' => 'paypal_experience_id',
					'type' => 'string',
					'sequence' => 0,
					'site_setting_category_id' => $this->SiteSettingCategory->id,
					'prevent_edit' => 1
				)
			)
		);
	}

}