<?php

$config = array(
	'EvPaypal' => array(
		// Client ID and currency will be appended automatically
		'includeScript' => 'https://www.paypal.com/sdk/js?components=buttons&intent=capture',

		'live' => array(
			'sendTotalsToPaypal' => true,
			'sendItemListToPaypal' => true,
		),

		'dev' => array(
			'clientId' => '',
			'clientSecret' => '',
			'testMode' => true,
			'brandName' => 'My Web Shop',
			'imageUrl' => '',
			'currency' => 'GBP',

			/*
			 * Send the payment totals (subtotal, tax and shipping) to PayPal. Disabling this means that only the grand
			 * total is sent to PayPal and the user won't be able to double check the totals once they have been sent
			 * to PayPal.
			 */
			'sendTotalsToPaypal' => false,

			/*
			 * Send a list of items that are being paid for to PayPal. Disabling this means that no items will be sent
			 * to PayPal and the user won't be able to double check their purchase once they have been set to PayPal.
			 */
			'sendItemListToPaypal' => false,

			'inputFields' => array(
				'noShipping' => 2,
				'addressOverride' => 1,
				'allowNote' => true
			),
			'flowConfig' => array(
				'landingPageType' => 'Billing',
				'bankTxnPendingUrl' => null
			),
			'presentation' => array(
				'localeCode' => 'GB'
			),
		)
	)
);
