<?php

App::uses('AppShell', 'Console/Command');
App::uses('PaypalLib', 'EvPaypal.Lib');

class PaypalShell extends AppShell {

	public $uses = array('EvSiteSettings.SiteSetting');

	/**
	 * loaded API context
	 */
	protected $_apiContext = null;

	/**
	 * clear the web profiles
	 *
	 */
	public function clearAllWebProfiles() {
		$profileList = \PayPal\Api\WebProfile::get_list($this->_apiContext());

		if (! empty($profileList)) {
			foreach ($profileList as $profile) {
				$this->deleteProfile($profile->getId());
			}
		} else {
			$this->out('<warning>No Profiles to delete</warning>');
		}
	}

	/**
	 * delete a profile
	 *
	 * @param 	string 	$profileId The profile ID to delete
	 * @return 	bool
	 */
	public function deleteProfile($profileId = null) {
		if (empty($this->args['0']) && empty($profileId)) {
			$this->out('<error>You must specify a profile ID</error>');
			return;
		}

		if ($profileId === null) {
			$profileId = $this->args['0'];
		}

		$PaypalProfile = new \PayPal\Api\WebProfile;
		$PaypalProfile->setId($profileId);

		try {
			$PaypalProfile->delete(
				$this->_apiContext()
			);

			$this->out('<success>Profile #' . $profileId . ' Deleted</success>');

			$this->clearProfileSettings($profileId);
		} catch (\Exception $e) {
			$this->out('<error>Failed to delete profile</error>');
		}
	}

	/**
	 * clear profile id from settings
	 *
	 * @param 	string 	$profileId 	Web profile Id
	 * @return 	bool
	 */
	public function clearProfileSettings($profileId = null) {
		if (empty($this->args['0']) && empty($profileId)) {
			$this->out('<error>You must specify a profile ID</error>');
			return;
		}

		if ($profileId === null) {
			$profileId = $this->args['0'];
		}

		$Setting = $this->SiteSetting->find(
			'first',
			array(
				'conditions' => array(
					'SiteSetting.array_slug' => 'paypal_experience_id',
					'SiteSetting.value' => $profileId
				),
				'callbacks' => false
			)
		);

		if (! empty($Setting)) {
			return $this->SiteSetting->save(
				array(
					'SiteSetting' => array(
						'id' => $Setting['SiteSetting']['id'],
						'value' => ''
					)
				)
			);
		}

		return false;
	}

	/**
	 * get the apiContext
	 *
	 * @return PayPal\Rest\ApiContext
	 */
	protected function _apiContext() {
		if ($this->_apiContext !== null) {
			return $this->_apiContext;
		}

		$config = PaypalLib::getConfig();
		$this->_apiContext = PaypalLib::apiContext($config);

		return $this->_apiContext;
	}
}
