<?php

/**
 * Library file to share some stuff between component nad shell
 */
class PaypalLib {

	/**
	 * get the paypal config
	 *
	 * @return 	array 	$config 	Return the paypal config array
	 */
	public static function getConfig() {
		if (Configure::read('app.environment') == 'PRODUCTION') {
			return Configure::read('EvPaypal.live');
		} else {
			return Configure::read('EvPaypal.dev');
		}
	}

	/**
	 * get the ApiContext
	 *
	 * @param 	array 	$config 	The paypal config array
	 * @return 	PayPal\Rest\ApiContext
	 */
	public static function apiContext($config) {
		$apiContext = new \PayPal\Rest\ApiContext(
			new \PayPal\Auth\OAuthTokenCredential(
				$config['clientId'],
				$config['clientSecret']
			)
		);

		$options = [];

		if ($config['testMode']) {
			$options['mode'] = 'sandbox';
		} else {
			$options['mode'] = 'live';
		}

		// @link https://developer.paypal.com/webapps/developer/docs/api/#inputfields-object
		$apiContext->setConfig(
			$options
		);

		return $apiContext;
	}
}
