<?php
/*
	EXAMPLE TEMPLATE SHOWING VARIABLES TO USE
*/
?>
<div class='row gutterless content__inner'>

	<div class="col-12">
		<?php if (isset($page['Page']['title']) && ! empty($page['Page']['title'])): ?>
			<h1><?php echo $page['Page']['title']; ?></h1>
		<?php endif; ?>

		<?php if (isset($page['Page']['body']) && ! empty($page['Page']['body'])): ?>
			<?php echo $page['Page']['body']; ?>
		<?php endif; ?>
	</div>

	<?php if (isset($partners) && ! empty($partners)): ?>
		<div class="partners">

			<?php foreach ($partners as $partner): ?>

				<div class="col-4">
					<div class="partner">

						<?php if (isset($partner['Image']['0']) && ! empty($partner['Image']['0'])): ?>
							<?php
								$image = $this->Image->resize(
									$partner['Image']['0'],
									array(
										'alt' => $partner['Partner']['name']
									)
								);

								if (isset($partner['Partner']['url']) && ! empty($partner['Partner']['url'])):

									$image = $this->Html->link(
										$image,
										$partner['Partner']['url'],
										array(
											'escape' => false,
											'target' => '_blank'
										)
									);
								endif;

								echo $image;

							?>
						<?php endif; ?>

						<?php

							$name = $partner['Partner']['name'];

							if (isset($partner['Partner']['url']) && ! empty($partner['Partner']['url'])):

								$name = $this->Html->link(
									'<i class="fa fa-external-link"></i> ' . $name,
									$partner['Partner']['url'],
									array(
										'escape' => false,
										'target' => '_blank'
									)
								);
							else:

								$name = '<a href="#">' . $name . '</a>';

							endif;

							echo $name;
						?>

					</div>
				</div>

			<?php endforeach; ?>

		</div>
	<?php endif; ?>

</div>