<?php
App::uses('EvPartnersAppModel', 'EvPartners.Model');
/**
 * Partners Model
 *
 */
class Partner extends EvPartnersAppModel {

	public $actsAs = array(
		'Routable.Routable' => array(
			'alias' => 'partner/:displayField',
			'config' => 'EvPartners'
		),
		'MetaData.Meta'
	);

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank')
			),
		),
	);

	public $imageSlots = array(
		'main' => array(
			'slots' => 1,
			'fields' => array()
		)
	);


	/**
	 * get the partners that have been tagged to the slider
	 *
	 * @return array
	 */
	public function getSliderPartners()
	{
		return $this->find(
			'all',
			array(
				'conditions' => array(
					'Partner.is_active' => 1,
					'Partner.add_to_slider' => 1
				),
				'order' => 'Partner.sequence ASC',
				'contain' => array(
					'Image'
				)
			)
		);
	}

}
