<?php

App::uses('EvPartnersAppController', 'EvPartners.Controller');

class PartnersController extends EvPartnersAppController {

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		unset($fields['Partner.sequence']);

		return $fields;
	}

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'index'
		));
	}

	public function index() {
		$Model = $this->{$this->modelClass};

		// see if there is a linked content page
		$pageId = Configure::read('EvPartners.page_id');

		if (! empty($pageId)) {
			$this->assignPage($pageId, 'page');
		}

		$this->set(
			'partners',
			$Model->find(
				'all',
				array(
					'conditions' => array(
						'Partner.is_active' => 1
					),
					'order' => 'Partner.sequence ASC',
					'contain' => array(
						'Image'
					)
				)
			)
		);

		$this->view = 'EvPartners.Partners/index';
	}

	public function view($id) {
		$Model = $this->{$this->modelClass};

		$partner = $Model->readForView($id);

		if (empty($partner)) {
			throw new NotFoundException();
		}

		// Fall back incase no page is found
		$this->set('title_for_layout', $partner['Partner']['name']);
		$this->Meta->set($partner);

		$this->set('partner', $partner);

		$this->view = 'EvPartners.Partners/view';
	}

}
