#EvPageField

This plugin adds support for individual custom fields per page, and is intended to replace the blocks system currently used on pages.

This was created as the blocks system requires that a block be shown for all pages in the admin area, so creating a block called 'Homepage about block' would show on every admin form, for every page, which will confuse clients.

To rectify this, this plugin has an admin section to create new fields for each page. You select the page you want the field to work on, and it'll then show as part of the standard admin edit page, and only for the page you selected it to work for.

It also allows you to use any of the standard field types, such as string, html, integer, boolean, etc.

This is also fully compatible with EvTranslation, allowing you to create multi-lingual pages with unlimited custom fields per page.

##Installation
To install the plugin, require it in composer as usual.

In your system bootstrap file add the following to the CakePlugin::loadAll array:

<pre>'EvPageField' => array(
	'bootstrap' => true,
)</pre>

Next, open your app's page model and add 'EvPageField.Field' to the actsAs array. It should look something like this:

<pre>    public $actsAs = array(
        'EvTranslation.Translatable' => array(
            'excluded_fields' => array(
                'view_template'
            )
        ),
        'EvPageField.Field'
    );</pre>
    
Note that the above example includes EvTranslation being loaded in as well.

Next, open your app page controller file. 

In your beforeFilter method, you'll need to load in the PageField helper and component, like so:

<pre>$this->helpers[] = 'EvPageField.Field';
$this->pageField = $this->Components->load('EvPageField.PageField');
$this->pageField->init($this->request);</pre>

Because we need to send the current page id (if set) through to the component class, you'll need to use a custom _adminFormFields method that passes the ID in.

Create a new method called something like _adminFormFieldsCustom($id = null);

Inside there, load in the existing fields by doing:

<pre>$fields = parent::_adminFormFields();</pre>

Then if you're running EvTranslation, add this line:

<pre>$translations = $this->translation->_adminFormFieldsTranslated($this->request, $fields);</pre>

Next add the following two lines (note that the second and third lines are only needed if you're running EvTranslation):

<pre>$fields = $this->pageField->_adminFormFieldsPageFields($this->request, $fields, $id);

$translations = $this->pageField->_adminFormFieldsPageFieldsTranslated($this->request, $translations, $id);

$this->set('translations', $translations);</pre>

Finally, create your custom admin_edit method and run the _adminFormFieldsCustom method It should look something like this - note that the $this->view line is only needed for EvTranslate

<pre>    public function admin_edit($id = null) {

        parent::admin_edit($id);

        $this->request = $this->pageField->loadFields($id, $this->request);

        $this->set('fields', $this->_adminFormFieldsCustom($id));

        $this->view = 'admin_form';

        return;
    }</pre>
    
    
And that's it...it just works! :P


##Usage

To load in any of the blocks, just do this inside one of your page views:

<pre>echo $this->Field->show('your_page_slug);</pre>

Currently you can load in any slug from any page - which in one sense is a good thing and in another is bad. Just make sure your field slugs are unique and you should't have any problems.

##Adding Fields
To add new fields, go to /admin/ev_page_field/page_fields/ 

This page shouldn't be added to the sidebar menu as clients have no need to access it - it serves no purpose to them.


###Future feature ideas

- Integration into the core to replace the blocks system
- Support for 'file' and 'image' fields (its really bad practice that we have to create tabs for every single image type on a page).
- Support for repeaters (Ask Rick what this means - too long to explain)
- Support for page types where you assign a 'type template' to a page, and it automatically adds fields to that page type. (Ask Rick for an in-depth explination).
- Support for dynamic field types that can do things like list pages to link to.

