<?php
/**
 * Field Behaviour Class
 *
 *
 * @author Rick Mills <rick@evoluted.net>
 * @license http://www.opensource.org/licenses/mit-license.php The MIT License
 */
class FieldBehavior extends ModelBehavior {

    /**
     * Set up the model behaviour
     *
     * This is where we set up all the settings needed for this behavior.
     *
     * @param  Model  $Model    Model object
     * @param  array  $settings Individual model settings
     */
    public function setup(Model $Model, $settings = array()) {




    }

    public function afterSave(Model $model, $created, $options = array())
    {
        $model_data = $model->data;

        $this->pageFields = ClassRegistry::init('EvPageField.PageField');

        $translation_records = array();

        if (isset($model_data['Page']['_PageFields'])) {
            foreach ($model_data['Page']['_PageFields'] as $field_id => $field_value) {

                // Main english field value
                $updated_data = array(
                    'id' => $field_id,
                    'value' => $field_value['value']
                );

                $this->pageFields->save($updated_data);
            }

            // If EvTranslation is in use, save any translations.
            if (Configure::read('EvPageField.enable_translations')) {

                $this->TranslationPhrase = ClassRegistry::init('TranslationPhrase');
                $this->TranslationTranslation = ClassRegistry::init('TranslationTranslation');

                foreach ($model_data['Page']['_TranslatedPageFields'] as $key => $value) {

                    // All translation values
                    if (strstr($key, 'lang_')) {
                        // The field is a language translation. Now we need to extract the field name and
                        // the language id from the variable. These are stored as lang_<ID>_<FIELD>
                        $lang_var = ltrim($key, 'lang_');
                        $lang_var = explode("_", $lang_var, 4);

                        $language_id = $lang_var[0];
                        $model_name = $lang_var[1];
                        $model_id = $lang_var[2];
                        $lang_field = $lang_var[3];

                        // We want to check to see if a translation phrase already exists.
                        $phrase = $this->TranslationPhrase->find('first', array(
                            'conditions' => array(
                                'model' => 'PageField',
                                'model_id' => $model_id,
                                'model_field' => $lang_field
                            )
                        ));

                        // Check to see if the phrase already exists. If it doesnt, we'll create it.
                        if (empty($phrase)) {

                            $phrase_data = array(
                                'model' => 'PageField',
                                'model_id' => $model_id,
                                'model_field' => $lang_field,
                                'translation_phrase_group_id' => null,
                                'is_hidden' => '1',
                                'is_active' => '1'
                            );

                            $phrase = $this->TranslationPhrase->save($phrase_data);
                        }

                        if (isset($phrase['TranslationPhrase']['id'])) {

                            // The language phrase exists. Now check to see if we've already stored a
                            // translation. If we have, we'll overwrite it. Otherwise, we'll create it.
                            $translation = $this->TranslationTranslation->find('first', array(
                                'conditions' => array(
                                    'translation_language_id' => $language_id,
                                    'translation_phrase_id' => $phrase['TranslationPhrase']['id']
                                )
                            ));

                            // Check to see if we've got a translation record
                            if (! empty($translation)) {

                                // A record exists! Delete it!
                                $this->TranslationTranslation->delete($translation['TranslationTranslation']['id']);
                            }

                            // Now create a new record
                            $translation_data = array(
                                'translation_language_id' => $language_id,
                                'translation_phrase_id' => $phrase['TranslationPhrase']['id'],
                                'translation' => $value
                            );

                            $translation_records[] = $translation_data;
                        }
                    }
                }
            }
        }

        if (! empty($translation_records)) {
            return $this->TranslationTranslation->saveAll($translation_records);
        }

        return true;
    }
}