<?php
App::uses('Folder', 'Utility');
App::uses('File', 'Utility');
App::uses('ArrayUtil', 'EvCore.Lib');

class FieldUtil
{
    public static $request;
    public static $model;
    public static $field_data;

    public static function init($request)
    {
        $model = ClassRegistry::init('EvPageField.PageField');
        self::$model = $model;
        $fields = $model->find('all', array(
            'conditions' => array(
                'is_active' => '1'
            )
        ));

        $field_data = array();

        foreach ($fields as $field) {

            $field_data[$field['PageField']['field_slug']] = $field['PageField']['value'];

        }

        self::$field_data = $field_data;
    }

    public static function show($field_slug)
    {
        if (array_key_exists($field_slug, self::$field_data)) {
            return self::$field_data[$field_slug];
        }

        return null;
    }

    public static function export()
    {
        return self::$field_data;
    }

    public static function _adminFormFieldsPageFields($request, $fields, $id = null)
    {
        // Add extra fields for custom page field data
        if ($id > 0) {
            $pageFields = self::$model->find('all', array(
                'conditions' => array(
                    'PageField.page_id' => $id
                )
            ));

            if (! empty($pageFields)) {

                $new_fields = array();
                $last_field = null;
                foreach ($pageFields as $field) {

                    $new_fields['_PageFields.' . $field['PageField']['id'] . '.value'] = array(
                        'type' => $field['PageField']['type'],
                        'label' => $field['PageField']['title']
                    );

                    $last_field = 'PageField.' . $field['PageField']['id'] . '.value';

                }

                // Add the page fields to the fields array
                $fields = array_merge($fields, $new_fields);

                // Move the is_active, created and updated fields to the end of the field list.

                $fields = ArrayUtil::moveItem($fields, 'Page.is_active', $last_field);
                $fields = ArrayUtil::moveItem($fields, 'Page.created', 'Page.is_active');
                $fields = ArrayUtil::moveItem($fields, 'Page.modified', 'Page.created');
            }
        }

        return $fields;
    }

    public static function _adminFormFieldsPageFieldsTranslated($request, $translations, $id = null)
    {
        if ($id > 0) {

            $pageFields = self::$model->find('all', array(
                'conditions' => array(
                    'PageField.page_id' => $id,
                    'PageField.is_active' => 1
                )
            ));

            // Add our page fields into the translation system manually.
            foreach ($translations as $language_id => $translation) {

                if (! empty($pageFields)) {

                    $new_lang_fields = array();

                    foreach ($pageFields as $field) {

                        $new_lang_fields['_TranslatedPageFields.lang_' . $language_id . '_PageField_' . $field['PageField']['id'] .  '_value'] = array(
                            'type' => $field['PageField']['type'],
                            'label' => $field['PageField']['title'],
                            'default' => '',
                            'length' => '',
                            'charset' => 'latin1',
                            'collate' => 'latin1_swedish_ci'
                        );
                    }
                    if (isset($translations[$language_id]['fields']) && is_array($translations[$language_id]['fields'])) {
                        $translations[$language_id]['fields'] = array_merge($translations[$language_id]['fields'], $new_lang_fields);
                    }
                }
            }
        }

        return $translations;
    }

    public static function loadFields($id = null, $request)
    {
        // Load in page field data.
        if ($id > 0) {
            $pageFields = self::$model->find('all', array(
                'conditions' => array(
                    'PageField.page_id' => $id
                )
            ));

            $field_data = array();
            $field_ids = array();
            foreach ($pageFields as $field) {

                $field_data[$field['PageField']['id']] = $field['PageField'];
                $field_ids[] = $field['PageField']['id'];

            }

            $request->data['_PageFields'] = $field_data;

            // Load in translation values for page fields if we're using EvTranslation
            if (Configure::read('EvPageField.enable_translations')) {
                $translationPhrase = ClassRegistry::init('EvTranslation.TranslationPhrase');

                $phrases = $translationPhrase->find('all', array(
                    'conditions' => array(
                        'model' => 'PageField',
                        'model_id' => $field_ids,
                        'model_field' => 'value'
                    ),
                    'contain' => array(
                        'TranslationTranslation'
                    )
                ));

                if (! empty($phrases)) {

                    foreach ($phrases as $phrase) {

                        if (! empty($phrase['TranslationTranslation'])) {

                            foreach ($phrase['TranslationTranslation'] as $translation) {

                                $request->data['_TranslatedPageFields']['lang_' .  $translation['translation_language_id'] . '_PageField_' . $phrase['TranslationPhrase']['model_id'] . '_value'] = $translation['translation'];

                            }
                        }
                    }
                }
            }
        }
        //pr($request);
        return $request;
    }
}