<?php

App::uses('Component', 'Controller');
App::uses('FieldUtil', 'EvPageField.Lib');

class PagefieldComponent extends Component
{
    private $__controller = null;

    /**
     * Sets a reference to the calling controller from within the component.
     *
     * @see Component::initialize()
     */
    public function initialize(Controller $controller) {

        parent::initialize($controller);

        $this->__controller = $controller;
    }

    /**
     * magic method to check if the function exists in the lib file and call it if so
     * if not, it will try and return the string we were trying to Inflect
     * if it can't do that, it will just return false
     *
     */
    public function __call($name, $arguments)
    {
        if (method_exists('FieldUtil', $name)) {

            return call_user_func_array('FieldUtil::' . $name, $arguments);
        }

        // we can't find it, return false
        return false;
    }

}