# EvNewsletterSignups

## Installation

Simply add EvNewsletterSignups to the `install.php` file within the Config directory and run `Console/cake installer core` once you have added all the other plugins you will need.

If this has already been run, simply run `Console/cake installer plugin EvNewsletterSignups`.

The installer will automatically setup the database tables and create a link in the admin menu to download the list of sign ups.

## How it works

The plugin works by posting the signup form to the same page and having a component included on that same page. The component then runs on the built in callback methods to automatically check the post variables and sign the user up or display error if needed.

The plugin only requires email as default but can handle extra fields which can be defined within the config file. These will be json'd and stored in a text field on the database row. Upon creating a CSV export, these are decoded and then placed into the CSV along with the email.

## Setup

Once the installer is run, you can setup an extra fields within the config, these are optional. If you do require extra fields, these can be defined in the standard format used throughout the CMS. Any html attribute can be provided in this array. To validate an extra field provide an array of `validate` with validation rules inside.

	'extraFields' => array(
		'name' => array(
			'type' => 'string',
			'label' => 'Name',
			'class' => 'class-name',
			'validate' => array(
				'required' => array(
					'rule' => 'notBlank',
					'message' => 'Name cannot be left blank'
				)
			)
		)
	)

Within the template include the element bundled with the plugin to display the signup form.

	<?=$this->element('EvNewsletterSignups.signup-form')?>

Within the controller you need to add the component and the helper to their respective arrays, this can be done by overriding the AppControllers Constructor to make it available on every page.

	public function __construct($request = null, $response = null) {
		if (CakePlugin::loaded('EvNewsletterSignups')) {
			$this->components[] = 'EvNewsletterSignups.Signups';
			$this->helpers[] = 'EvNewsletterSignups.Signups';
		}

		parent::__construct($request, $response);
	}

Within the config, you can also customise the flash success / fail message that is displayed.

### Field Validation

The plugin will use the hardcoded `success` and `fail` validation messages from its config file as default. To alter this behaviour there is an option to assign the `fail` value to `false`. Switching the `fail` value to `false` will case the Model validation error to display rather than the hardcoded, plugin config based, entry.

## Third Party Integrations

We now have the ability to integrate Mailchimp, Campaign Monitor and Capsule CRM. This allows us to also subscribe a user to any of these depending on requirement
### Mailchimp
#### Installation
You will need to install https://github.com/dereuromark/cakephp-mailchimp

You can bring this in via Composer as stated in https://github.com/dereuromark/cakephp-mailchimp/blob/master/docs/Install.md

Mailchimp has a built in field labelled "Preferred format". To allow users to choose, you can add an extra field with the key of "emailType". The API only accepts "text" or "html" as values.

#### Configuration
Simply change the 'mailchimp' variable to the array seen in the Config file.

**API Key**: This can be found under Account > Extras > API Keys

**Default List ID**: After you've created your list, click on the list and choose (from the top bar) Settings > List Name and Defaults. the list ID will be shown on the right-hand column.

##### Environment switching
The mailchimp configuration can be switched based on the current runtime environment. Provide a mailchimp config for each environment under the keys of `dev` and `live`. The live config is only used when the site is on a production environment. The dev config is used on any other environment if it has been provided. If no environment key has been provided then it assumes there is only 1 config.

### Campaign Monitor
#### Installation
You will need to install https://github.com/campaignmonitor/createsend-php

You can bring this in via Composer as stated in https://github.com/campaignmonitor/createsend-php/blob/master/README.md

#### Configuration
**API Key**: This can be found under Account Settings > API Key (you will need to click "show API key")

**Default List ID**: After you've created your list, click in to the list, then click the "change name/type" link under the title. The List ID will be shown at the bottom of the page.

**defaultFields**: This array is used to store default field names. This (for now at least) is used only for Name. If you wish to use Name, please enter the key you used in the ExtraFields array here, eg

```
'defaultFields' => array(
	'name' => 'key_used_in_extras_array'
)
```


### Capsule CRM
#### Installation
You will need no third-party code to use this. As of writing, the PHP/CakePHP Integration kits found were for the V1 API whereas Capsule has recently moved on to V2.

#### Accepted Fields
To see the list of fields which will be accepted by Capsule, please see https://developer.capsulecrm.com/v2/operations/Party#createParty
Please note; while there is no bespoke "name" field for a person (only firstName and lastName are accepted), the plugin will handle a singular name field in the Newsletter and split it out appropriatly if the bespoke firstName/lastName fields aren't used.

#### Configuration
**Access Token**: Assuming you have access to the Capsule Dashbaord for the relevant client, you will need to create a Personal Access Token. This is done by the following steps:
* From the Dashboard, click the Profile dropdown on the top right ("Client Name") and click "My Preferences"
* Along the left-hand side, click on "API Authentication Tokens"
* Ignore the API key displayed here - this is not what we need. Instead, click on the "Personal Access Tokens" tab
* If a token has not already been created here, click on the "Generate new API token" button and create the required token

## Exporting

To export the signups to CSV you need to add a menu item that links to `/admin/ev_newsletter_signups/signups/export`. For a date filter, the route `/admin/ev_newsletter_signups/signups/export_range` can be used instead.
