<?php

class NewsletterSignups {

/**
 * Signup a user to the newsletter. This encodes the extra fields so it doesn't need to be done before hand.
 *
 * @param array $data The array of the signup. Keys should be email and extras. The extras are json_encoded.
 * @return array the key status holds success or error, if it's an error, errors will be created
 */
	public function signup($data) {
		$Signup = EvClassRegistry::init('EvNewsletterSignups.Signup');

		$originalSignupValidation = $Signup->validate;

		//Add validation from extra fields to singup
		$extras = Configure::read('EvNewsletterSignups.extraFields');
		if (!empty($extras)) {
			foreach ($extras as $field => $fieldAttr) {
				if (empty($fieldAttr['validate'])) {
					continue;
				}

				$Signup->validate[$field] = $fieldAttr['validate'];
			}
		}

		$Signup->create();
		$Signup->set($data);

		//Validate before save so that the extras can be validated before they are json'd
		if (!$Signup->validates()) {
			return [
				'status' => 'error',
				'errors' => $Signup->validationErrors,
			];
		}

		//Reset the validation so the signup can save without the extras being validated.
		$Signup->validate = $originalSignupValidation;

		if (!$Signup->save($data)) {
			return [
				'status' => 'error',
				'errors' => $Signup->validationErrors,
			];
		}

		return [
			'status' => 'success'
		];
	}

/**
 * Pass an array of data through to get formatted correctly for signups.
 *
 * @param array $data        The data to format. Must include email as a top level key.
 * @param array $extraFields Fields to resitct to the extras. Left empty all will be added. If set to false none will be added.
 * @return array The formatted data.
 */
	public function formatSignupData($data, $extraFields = []) {
		$signupData = [];

		if (!isset($data['email'])) {
			return false;
		}

		$signupData['email'] = $data['email'];

		if (isset($data['extras'])) {
			$signupData['extras'] = $data['extras'];
		} else {
			unset($data['email']);

			$extraData = [];

			if (is_array($extraFields) && !empty($extraFields)) {
				foreach ($data as $field => $value) {
					//Check if the field is to be added to the extra data.
					if (in_array($field, $extraFields)) {
						$extraData[$field] = $value;
					}
				}
			} elseif ($extraFields !== false) {
				$extraData = $data;
			}

			$signupData['extras'] = $extraData;
		}

		return $signupData;
	}
}
