<?php

App::uses('EvNewsletterSignupsAppController', 'EvNewsletterSignups.Controller');
App::uses('InflectorExt', 'EvInflector.Lib');

class SignupsController extends EvNewsletterSignupsAppController {

	/**
	 * beforeFilter callback, redefine to allow adminAction
	 *
	 */
	public function beforeFilter() {
		$this->adminActions[] = 'admin_export';
		$this->adminActions[] = 'admin_export_range';

		parent::beforeFilter();
	}

	/**
	 * export all the signups to csv
	 */
	public function admin_export() {
		// process the headers
		$extraFields = Configure::read('EvNewsletterSignups.extraFields');

		$_header = array('Email');
		foreach ($extraFields as $name => $attr) {
			if (! empty($attr['label']) && ! is_array($attr['label'])) {
				$_header[] = $attr['label'];
			} elseif (! empty($attr['label']['label'])) {
				$_header[] = $attr['label']['label'];
			} else {
				$_header[] = InflectorExt::humanize($name);
			}
		}

		// process the signups
		$data = array();

		$query = [];
		if (!empty($this->request->data['Export']['from'])) {
			$query['conditions']['created >='] = $this->request->data['Export']['from'];
		}
		if (!empty($this->request->data['Export']['to'])) {
			$query['conditions']['created <='] = $this->request->data['Export']['to'];
		}

		$signups = $this->Signup->find('all', $query);
		$extraFieldNames = array_keys($extraFields);

		foreach ($signups as $item) {
			$row = array();
			$row[] = $item['Signup']['email'];

			foreach ($extraFieldNames as $field) {
				if (! empty($item['Signup']['extras'][$field])) {
					$row[] = $item['Signup']['extras'][$field];
				} else {
					$row[] = '';
				}
			}

			$data[] = $row;
		}

		$_serialize = 'data';

		$this->viewClass = 'CsvView.Csv';
		$this->set(compact('data', '_serialize', '_header'));
		$this->response->download('Newsletter-Signups-' . date("j-M-Y") . '.csv');
	}

/**
 * Screen for adding a range to the export call
 *
 * @return void
 */
	public function admin_export_range() {
		$this->set('exportUrl', [
			'plugin' => 'ev_newsletter_signups',
			'controller' => 'signups',
			'action' => 'export'
		]);
		$this->view = 'EvNewsletterSignups.Signups/admin_export_range';
	}

}
