<?php

App::uses('AppComponent', 'Controller/Component');

App::uses('NewsletterSignups', 'EvNewsletterSignups.Lib');

class SignupsComponent extends AppComponent {

/**
 * Component startup - check for the form being submitted
 *
 * @param Controller $Controller The controller the component is attached to
 * @return void
 */
	public function startup(Controller $Controller) {
		if ($this->_controller->request->is('post') && ! empty($this->_controller->request->data['Newsletter']['Signup'])) {
			$signupData = $this->_controller->request->data['Newsletter']['Signup'];

			$signedUp = $this->_signupToNewsletter($signupData);
			if ($signedUp['status'] == 'success') {
				$this->_controller->Flash->success(
					Configure::read('EvNewsletterSignups.flashMessage.success'),
					array(
						'key' => 'newsletter-flash'
					)
				);

				unset($this->_controller->request->data['Newsletter']);
			} else {
				$flashErrorMessage = [];
				$displayValidationErrors = true;

				if (Configure::check('EvNewsletterSignups.flashMessage.fail')) {
					$flashErrorMessage['description'] = Configure::read('EvNewsletterSignups.flashMessage.fail');

					//Orginally the behaviour was to have a custom flash message or validation errors. To have
					//both an extra config setting needs to be added.
					if (isset($flashErrorMessage['displayValidationErrors']) && !$flashErrorMessage['displayValidationErrors']) {
						$displayValidationErrors = false;
					}
				}

				if (!empty($signedUp['errors']) && $displayValidationErrors) {
					$flashErrorMessage['list'] = $signedUp['errors'];
				}

				$this->_controller->Flash->fail(
					$flashErrorMessage,
					array(
						'key' => 'newsletter-flash'
					)
				);
			}
		}
	}

/**
 * Signs up the user to the newsletter. Override for any special functionality
 *
 * @param array $signupData
 * @return array Status object with errors if not successful
 */
	protected function _signupToNewsletter($signupData) {
		return NewsletterSignups::signup($signupData);
	}

}
