$(document).ready(function() {

	$('.newsletter-signup').bind('submit', function(e) {
		e.preventDefault();

		var href = $(this).attr('action');

		var data = {};
		$('#NewsletterSignupViewForm').find('input').each(function (index, element) {
			element = $(element);
			name = element.attr('name');
			value = element.val();

			//If the input wasn't data then we don't want to add it to the array.
			if (name.indexOf('data') !== 0) {
				return;
			}

			dataName = name.split('[');
			dataName = dataName[dataName.length - 1];
			dataName = dataName.replace(']', '');
			data[dataName] = value;
		});

		$.ajax({
			'type' : 'POST',
			'url' : href,
			'cache': false,
			'data' : data,
			success: function(data, textStatus, jqXHR) {

				$('#NewsletterSignupsNotification').css('display', 'none').html(data);
				$('#NewsletterSignupsNotification').slideDown();

				$('#NewsletterSignupName').val('Name');
				$('#NewsletterSignupEmail').val('Email');

				setTimeout('closeMessage("NewsletterSignupsNotification");', 5000);
			},
			error: function(jqXHR, textStatus, errorThrown) {

				$('#NewsletterSignupsNotification').css('display', 'none').html('There was an error processing your sign up. Please try again.');
				$('#NewsletterSignupsNotification').slideDown();

				setTimeout('closeMessage("NewsletterSignupsNotification");', 4000);
			}
		});

	});

});

function closeMessage(div_id)
{
	if (typeof div_id != 'undefined') {

		$('#' + div_id).slideUp('normal', function(e) {

			$('#' + div_id).empty();

		});
	}
}
