<?php

	echo $this->Form->create('EvNewsletterSignups.NewsletterSignup', array(
		'class' => isset($form_class) ? $form_class." newsletter-signup" : 'newsletter-signup',
		'url' => array(
			'plugin' => 'ev_newsletter_signups',
			'controller' => 'newsletter_signups',
			'action' => 'signup'
		)
	));

	if (isset($title)) {

		echo $title;
	}

	$name_attr = $email_attr = $submit_attr = array();
	if (isset($name_field)) {
		unset($name_field['id']);
		$name_attr = $name_field;
	}

	if (isset($email_field)) {
		unset($email_field['id']);
		$email_attr = $email_field;
	}

	if (isset($submit_field)) {
		unset($submit_field['id']);
		$submit_attr = array_merge(array('type' => 'submit'), $submit_field);
	} else {
		$submit_attr = array('type' => 'submit');
	}

	echo '<div id="NewsletterSignupsNotification">';
	echo $this->Session->flash('newsletter');
	echo '</div>';


	echo $this->Form->input('NewsletterSignup.name', $name_attr);

	echo $this->Form->input('NewsletterSignup.email', $email_attr);

	echo $this->Form->input('Sign Up', $submit_attr);

	echo $this->Form->end();


	// include in newsletter JS
	$this->Html->script('EvNewsletterSignups.newsletter-signup', array(
		'inline' => false
	));

	echo $this->Html->css('EvNewsletterSignups.newsletter-notifications');
