<?php

App::uses('EvNewsletterSignupsAppController', 'EvNewsletterSignups.Controller');

class NewsletterSignupsController extends EvNewsletterSignupsAppController {

	public $uses = 'EvNewsletterSignups.NewsletterSignup';

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow('signup');
	}


	public $adminActions = array(
		'admin_export'
	);

	public function signup() {
		$Model = $this->{$this->modelClass};

		if (!empty($this->request->data)) {
			// reformat if it's ajax post
			if (!isset($this->request->data['NewsletterSignup'])) {
				$data['NewsletterSignup']['email'] = $this->request->data['email'];
				// If the name field is not present in the form we don't want to save/validate it.
				if (isset($data['name'])) {
					$data['NewsletterSignup']['name'] = $this->request->data['name'];
				}
			} else {
				$data = $this->request->data;
			}

			if ($Model->save($this->request->data)) {

				// success, either return success for ajax or set to flash for displaying
				if ($this->request->is('ajax')) {

					return $this->render('EvNewsletterSignups.Notifications/success', 'ajax');

				} else {

					$this->Session->setFlash($this->render('EvNewsletterSignups.Notifications/success', ''), 'default', array(), 'newsletter');
				}

			} else {

				// failed, either return success for ajax or set to flash for displaying
				if ($this->request->is('ajax')) {

					return $this->render('EvNewsletterSignups.Notifications/error', 'ajax');

				} else {

					$this->Session->setFlash($this->render('EvNewsletterSignups.Notifications/error', ''), 'default', array(), 'newsletter');
				}
			}
		}

		// no post
		$this->redirect(
			$this->referer()
		);

		return;
	}

	public function admin_export() {

		$output = "";

		$data = $this->NewsletterSignup->find('all');

		if (!empty($data)) {

			$output = "Name,Email\n";

			foreach ($data as $subscriber) {

				if (! empty($subscriber['NewsletterSignup']['email'])) {

					$output .= stripslashes($subscriber['NewsletterSignup']['name']).",";
					$output .= stripslashes($subscriber['NewsletterSignup']['email'])."\n";
				}
			}
		} else {

			$output = __('There are no emails in the newsletter mailing list');
		}

		$date = date("j_M_Y");

		// setup the headers
		$this->response->disableCache();
		$this->response->length(strlen($output));
		$this->response->type('csv');
		$this->response->download("newsletter_signups_".$date.".csv");
		$this->response->body($output);

		// output csv
		$this->autoRender = false;
		$this->response->send();

		exit;
	}

}
