Navigation Plugin
=================

This plugin adds menus to an app.

---

Setup:

	Schema:

		You will need a menu table in your database:-

			CREATE  TABLE IF NOT EXISTS `menus` (
			  `id` INT NOT NULL AUTO_INCREMENT ,
			  `parent_id` INT NULL ,
			  `lft` INT NULL ,
			  `rght` INT NULL ,
			  `name` VARCHAR(45) NOT NULL ,
			  `url` VARCHAR(128) NULL ,
			  `pattern` VARCHAR(1024) NULL ,
              `plugin` VARCHAR(45) NULL,
			  `model` VARCHAR(45) NULL ,
			  `model_id` INT NULL ,
			  `action` VARCHAR(45) NULL ,
			  `class` VARCHAR(45) NULL ,
			  `is_active` TINYINT(1) NOT NULL DEFAULT 0 ,
			  `created` DATETIME NULL ,
			  `modified` DATETIME NULL ,
			  PRIMARY KEY (`id`) ,
			  INDEX `fk_menus_menus1_idx` (`parent_id` ASC) ,
			  CONSTRAINT `fk_menus_menus1`
			    FOREIGN KEY (`parent_id` )
			    REFERENCES `evoluted_core`.`menus` (`id` )
			    ON DELETE NO ACTION
			    ON UPDATE NO ACTION)
			ENGINE = InnoDB;

	Load the plugin (this is already in core):-

		Add the following to /app/Config/bootstrap.php:

			CakePlugin::loadAll(array(
			    'Navigation'
			));

---

To associate a model with the menu, give it the Navigatable behaviour:-

	class MyModel extends AppModel {

		public $actsAs = array(
			'Navigation.Navigatable'
		);

	}

AppController has been setup to add the required menu fields to the admin form when the related model has the Navigatable behaviour. It will assume that you want to link to the 'view' action. This can be overridden:-

	class MyModel extends AppModel {

		public $actsAs = array(
			'Navigation.Navigatable' => array(
				'action' => 'display'
			)
		);

	}

In your model you can define a parent menu (Model::parentMenu) that any content will be put under.

---

##Using the Navigation Helper with Twitter Bootstrap

This code snippet shows a basic working example of how to configure the Navigation Helper within your view to work with native Twitter Bootstrap mark-up and classes.

    <?php
	     echo $this->Navigation->menu($primary_nav, array(
			    'class' => 'nav navbar-nav',
			    'id' => 'primary-nav',
			    'tag' => 'li',
			    'wrapTag' => 'ul',
			    'wrapClass' => 'dropdown-menu',
			    'childWrapTag' => false,
			    'childrenClass' => 'dropdown',
			    'activeClass' => 'active',
			    'activeTrailClass' => 'menu-item--active-trail',
			    'itemClassPrefix' => 'menu-item--',
			    'model' => 'Menu',
			    'childrenImageClass' => 'menu-item--has-children-image',
			    'childrenLinkAttr' => array(
				    'class' => 'dropdown-toggle',
				    'data-toggle' => 'dropdown',
				    'role' => 'button',
				    'aria-haspopup' => 'true',
				    'aria-expanded' => 'false'
	       		),
	       		'prepend' => '<i class="fa fa-chevron-right"></i>',
	       		'append' => '<i class="fa fa-chevron-right"></i>'
	      )
     );
    ?>

## Migrations

To add to the menus during migrations you can use the `MigrationUtil` library.

To create a menu item under a parent item use `createOnceWithParent`:-

```php
$navMigrationUtils = (new MigrationUtil)->init('EvNavigation.Menu');
$navMigrationUtils->createOnceWithParent(
    ['Menu.name' => 'Locations'],
    ['Menu.name' => 'Admin', 'Menu.parent_id' => null],
    [
        'Menu' => [
             'name' => 'Locations',
             'url' => '/admin/ev_lettings/locations',
             'pattern' => '#^/admin/ev_lettings/locations#',
             'requires_login' => 1,
             'is_active' => 1
         ]
    ]
);
```

To remove an item from a parent menu item use `deleteAllWithParent`:-

```php
$navMigrationUtils = (new MigrationUtil)->init('EvNavigation.Menu');
$navMigrationUtils->deleteAllWithParent(
    ['Menu.name' => ['Locations', 'Properties']],
    ['Menu.name' => 'Admin', 'Menu.parent_id' => null]
);
```

### Getting a Menu

You can use the `getMenu` method to retrieve a menu for the front-end. It accepts either the ID of the menu or the menu's system name as its first parameter:

```php
$siteMenu = $this->Menu->getMenu('site');
```

### Exporting Menus

Using the `EvMigrationUtil` library, menus can be exported as a migration. The parents will be created as part of the migration if they don't already exist. To export to a migration use:

	app/Console/cake EvMigrationUtil.Migration export EvNavigation.Menu menu_id

Replace `menu_id` with the menu ID from the CMS.

## Custom Routes
When getting a menu, menu items with associated data (through the navigatable behavior) have their menu url replaced with a route array instead of a url string. The route array that was produced works for standard CakePHP routes as well as routes used in EvRoutable. Any other route used on a site however would not work. Custom route arrays have been made available to deal with this. To produce custom route arrays for menu items, first you need to enable `use_custom_menu_routes` in the config. This does produce more queries so could create more overhead for a site, however menus received through `Menu->getMenu()` are cached so as long as you aren't creating menus manually it will cause no problems enabling this.

For each associated Model of a menu item that requires custom routes, add the `custom_route` behavior setting to the Navigatable behavior. The value of the `custom_route` should be a standard route array with the values you want in the route.

For dynamic routes, the standard route parameter tokens are available: `plugin`, `controller`, `action`. Use these as the values to any of the route parameters and prefix with `:` so that they are replaced by their values from the menu item itself.

A token is also available for the primary key field of the associated model data. Use `id`, `model_id`, `primaryKey` or the primaryKey field of the model, e.g. `$Model->primaryKey = 'primaryKey_field_of_the_model'`. Also prefix these with a `:`.

Additional fields can also be used as tokens to be inserted into the route parameters, to add them just use `:` followed by the field name, e.g. `:url_slug` or `:name`.

Examples of custom routes:
```
'custom_route' => [
	'plugin' => 'ev_shop',
	'controller' => 'products',
	'action' => 'view',
	':url_slug',
],
```

```
'custom_route' => [
	'plugin' => false,
	'controller' => ':controller',
	'action' => ':action',
	':model_id',
],
```

```
'custom_route' => [
	'unique'
	'route_alias',
	':uuid',
],
```
