<?php

App::uses('CakeEventListener', 'Event');

class ClearMenuPermissionsCacheListener implements CakeEventListener {

/**
 * The events that this listener should listen to and which functions to call when those events are fired.
 *
 * @return array Array of implement events.
 */
	public function implementedEvents() {
		return array(
			'EvCore.Model.EvCorePermission.afterSave' => 'clearMenuPermissionsCache',
		);
	}

/**
 * Clear the menu permissions cache because a permission has been updated
 *
 * @param CakeEvent $event The event that was fired.
 * @return void.
 */
	public function clearMenuPermissionsCache(CakeEvent $event) {
		Cache::clearGroup('EvNavigationMenuPermissions', 'EvNavigation_Permissions');

		return true;
	}
}
