<?php

/**
 * Pick the caching engine to use.  If APC is enabled use it.
 * If running via cli - apc is disabled by default. ensure it's available and enabled in this case
 *
 * Note: 'default' and other application caches should be configured in app/Config/bootstrap.php.
 *       Please check the comments in boostrap.php for more info on the cache engines available
 *       and their setttings.
 */
$engine = 'File';
if (extension_loaded('apc') && function_exists('apc_dec') && (php_sapi_name() !== 'cli' || ini_get('apc.enable_cli'))) {
	$engine = 'Apc';
}

// In development mode, caches should expire quickly.
$duration = '+999 days';
if (Configure::read('debug') >= 1) {
	$duration = '+10 seconds';
}

// Prefix each application on the same server with a different string, to avoid Memcache and APC conflicts.
$cachePrefix = '';
if (function_exists('getCachePrefix')) {
	$cachePrefix = getCachePrefix();
}


Cache::config('EvNavigation_Menus', array(
	'engine' => $engine,
	'prefix' => $cachePrefix . 'menus_',
	'path' => CACHE . 'menus' . DS,
	'serialize' => ($engine === 'File'),
	'duration' => $duration,
	'groups' => array(
		'Menus'
	)
));

Cache::config('EvNavigation_Permissions', array(
	'engine' => $engine,
	'prefix' => $cachePrefix . 'permissions_',
	'path' => CACHE . 'menus' . DS,
	'serialize' => ($engine === 'File'),
	'duration' => '+1 hours',
	'groups' => array(
		'EvNavigationMenuPermissions',
	)
));

$path = dirname(__FILE__);
$pluginDir = explode(DS, dirname($path . '../'));

$pluginName = array_pop($pluginDir);
$pluginConfig = Inflector::underscore($pluginName);
Configure::load($pluginName . '.config');

// Load overrides to settings if they exist
$configOverridePath = APP . 'Config' . DS;
$configOverride = 'Plugin' . DS . $pluginConfig . '.php';

if (file_exists($configOverridePath . $configOverride) && is_readable($configOverridePath . $configOverride)) {

	Configure::load($configOverride);
}

require_once (ROOT . DS . 'Plugin' . DS . 'EvNavigation' . DS . 'Config' . DS . 'events.php');
