<?php
class AddSystemNameToMenusTable extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'Add_system_name_to_menus_table';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = [
		'up' => [],
		'down' => [],
	];

	private $__migration = [
		'up' => [
			'create_field' => [
				'ev_navigation_menus' => [
					'system_name' => [
						'type' => 'string',
						'null' => true,
						'default' => null,
						'length' => 45,
						'collate' => 'utf8mb4_general_ci',
						'charset' => 'utf8mb4',
						'after' => 'name',
					],
					'indexes' => [
						'UNIQUE_SYSTEM_NAME' => [
							'column' => 'system_name',
							'unique' => true,
						],
					],
				],
			],
		],
		'down' => [
			'drop_field' => [
				'ev_navigation_menus' => [
					'indexes' => ['UNIQUE_SYSTEM_NAME'],
					'system_name'
				],
			],
		],
	];

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		$Menu = EvClassRegistry::init('EvNavigation.Menu');

		$menuSchema = $Menu->schema();

		$hasSystemName = isset($menuSchema['system_name']);
		if (($direction == 'up' && !$hasSystemName) || ($direction == 'down' && $hasSystemName)) {
			$this->migration = $this->__migration;
		}

		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction === 'down') {
			return true;
		}

		// Let's create a couple of system name's for our two main top level menus if they exist.
		$Menu = EvClassRegistry::init('EvNavigation.Menu');
		$menuItems = $Menu->find('all', [
			'conditions' => [
				'Menu.name' => ['Admin', 'Site'],
				'Menu.parent_id' => null,
			],
			'callbacks' => false,
		]);
		if (empty($menuItems)) {
			return true;
		}

		foreach ($menuItems as &$menuItem) {
			$menuItem['Menu']['system_name'] = InflectorExt::snake($menuItem['Menu']['name']);
		}
		return (bool)$Menu->saveMany($menuItems, ['validate' => false]);
	}
}
