<?php
class AddingRequiresLoginToMenus extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'adding_requires_login_to_menus';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'ev_navigation_menus' => array(
					'requires_login' => array('type' => 'boolean', 'null' => false, 'default' => true, 'after' => 'permission_level'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'ev_navigation_menus' => array('requires_login'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction == 'up') {
			//Find all the frontend menus and set them so they don't require login.
			$Menu = EvClassRegistry::init('EvNavigation.Menu');
			$adminParentMenu = $Menu->find(
				'first',
				[
					'conditions' => [
						'Menu.name' => 'Admin',
						'Menu.level' => 0,
					]
				]
			);

			if (!empty($adminParentMenu)) {
				$menus = $Menu->find(
					'threaded',
					[
						'conditions' => [
							'OR' => [
								'Menu.lft >' => $adminParentMenu['Menu']['rght'],
								'Menu.rght <' => $adminParentMenu['Menu']['lft'],
							],
						]
					]
				);

				$ids = $this->_getMenuIds($menus);

				if (!empty($ids)) {
					$menuData = [];
					foreach ($ids as $menuId) {
						$menuData[] = [
							'Menu' => [
								'id' => $menuId,
								'requires_login' => false,
							]
						];
					}

					if (!empty($menuData)) {
						$Menu->saveMany($menuData);
					}
				}
			}
		}

		return true;
	}

/**
 * Loop through a threaded array of menu items and pull out the menu id of each one.
 *
 * @param array $menuItems An array of menu items to get ids from.
 * @param array $menuIds   An array of the current menu ids.
 * @return array The found menu ids.
 */
	protected function _getMenuIds($menuItems, $menuIds = []) {
		foreach ($menuItems as $menuItem) {
			if (!empty($menuItem['Menu']['id'])) {
				$menuIds[] = $menuItem['Menu']['id'];
			}

			if (!empty($menuItem['children'])) {
				$menuIds = $this->_getMenuIds($menuItem['children'], $menuIds);
			}
		}

		return $menuIds;
	}
}
