<?php

App::uses('PluginInstallShell', 'shells');

class EvNavigationInstallShell extends PluginInstallShell
{
	public $uses = array(
		'EvNavigation.Menu'
	);

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run()
	{
		parent::run();

		$this->Menu->saveMany(
			array(
				array(
					'parent_id' => NULL,
					'lft' => 1,
					'rght' => 14,
					'name' => 'Admin',
					'url' => NULL,
					'pattern' => NULL,
					'class' => NULL,
					'is_active' => 1,
					'permission_level' => NULL
				),
				array(
					'parent_id' => 1,
					'lft' => 2,
					'rght' => 5,
					'name' => 'Users',
					'url' => '/admin/ev_core/users',
					'pattern' => '/^\\/admin\\/ev_core\\/users\\//',
					'class' => 'icon-user',
					'is_active' => 1,
					'permission_level' => NULL
				),
				array(
					'parent_id' => 2,
					'lft' => 3,
					'rght' => 4,
					'name' => 'User Group',
					'url' => '/admin/ev_core/user_groups',
					'pattern' => '/^\\/admin\\/ev_core\\/user_groups\\//',
					'class' => 'icon-users',
					'is_active' => 1,
					'permission_level' => 10
				),
				array(
					'parent_id' => 1,
					'lft' => 6,
					'rght' => 7,
					'name' => 'Menus',
					'url' => '/admin/ev_navigation/menus',
					'pattern' => '/^\\/admin\\/ev_navigation\\/menus\\//',
					'class' => 'icon-reorder',
					'is_active' => 1,
					'permission_level' => NULL
				),
				array(
					'parent_id' => 1,
					'lft' => 8,
					'rght' => 9,
					'name' => 'Pages',
					'url' => '/admin/ev_core/pages',
					'pattern' => '/^\\/admin\\/ev_core\\/pages\\//',
					'class' => 'icon-file-text',
					'is_active' => 1,
					'permission_level' => NULL
				),
				array(
					'parent_id' => 1,
					'lft' => 10,
					'rght' => 11,
					'name' => 'Site Settings',
					'url' => '/admin/ev_site_settings/site_settings',
					'pattern' => '/^\\/admin\\/ev_site_settings\\//',
					'class' => 'icon-cogs',
					'is_active' => 1,
					'permission_level' => NULL
				),
				array(
					'parent_id' => 1,
					'lft' => 12,
					'rght' => 13,
					'name' => 'Templates',
					'url' => '',
					'pattern' => '/^\/admin\/ev_templates\//',
					'plugin' => 'EvTemplates',
					'controller' => 'ev_templates.templates',
					'Model' => 'Template',
					'action' => 'index',
					'class' => 'icon-files-o',
					'is_active' => 1,
					'permission_level' => 10
				),
				array(
					'lft' => 15,
					'rght' => 16,
					'parent_id' => NULL,
					'name' => 'Site',
					'url' => NULL,
					'pattern' => NULL,
					'class' => NULL,
					'is_active' => 1,
					'permission_level' => NULL
				)
			)
		);
	}

}
