<?php
class AddingLevelsToMenus extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'Addeding_levels_to_menus';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'ev_navigation_menus' => array(
					'level' => array('type' => 'integer', 'null' => false, 'default' => 0, 'length' => 10, 'unsigned' => false, 'after' => 'rght'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'ev_navigation_menus' => array('level'),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		if ($direction == 'up') {
			//Save all the menus currently in the CMS so that they have the correct level depth after the migration
			//because otherwise they would all have 0 depth.
			$Menu = EvClassRegistry::init('EvNavigation.Menu');
			$menus = $Menu->find('all');

			if (!empty($menus)) {
				foreach ($menus as $menu) {
					$saveMenu = [
						'id' => $menu['Menu']['id'],
						'parent_id' => $menu['Menu']['parent_id'],
						'lft' => $menu['Menu']['lft'],
						'rght' => $menu['Menu']['rght'],
					];

					$Menu->save($saveMenu);
				}
			}
		}

		return true;
	}
}
