Navigation Plugin
=================

This plugin adds menus to an app.

---

Setup:

	Schema:

		You will need a menu table in your database:-

			CREATE  TABLE IF NOT EXISTS `menus` (
			  `id` INT NOT NULL AUTO_INCREMENT ,
			  `parent_id` INT NULL ,
			  `lft` INT NULL ,
			  `rght` INT NULL ,
			  `name` VARCHAR(45) NOT NULL ,
			  `url` VARCHAR(128) NULL ,
			  `pattern` VARCHAR(1024) NULL ,
              `plugin` VARCHAR(45) NULL,
			  `model` VARCHAR(45) NULL ,
			  `model_id` INT NULL ,
			  `action` VARCHAR(45) NULL ,
			  `class` VARCHAR(45) NULL ,
			  `is_active` TINYINT(1) NOT NULL DEFAULT 0 ,
			  `created` DATETIME NULL ,
			  `modified` DATETIME NULL ,
			  PRIMARY KEY (`id`) ,
			  INDEX `fk_menus_menus1_idx` (`parent_id` ASC) ,
			  CONSTRAINT `fk_menus_menus1`
			    FOREIGN KEY (`parent_id` )
			    REFERENCES `evoluted_core`.`menus` (`id` )
			    ON DELETE NO ACTION
			    ON UPDATE NO ACTION)
			ENGINE = InnoDB;

	Load the plugin (this is already in core):-

		Add the following to /app/Config/bootstrap.php:

			CakePlugin::loadAll(array(
			    'Navigation'
			));

---

To associate a model with the menu, give it the Navigatable behaviour:-

	class MyModel extends AppModel {

		public $actsAs = array(
			'Navigation.Navigatable'
		);

	}

AppController has been setup to add the required menu fields to the admin form when the related model has the Navigatable behaviour. It will assume that you want to link to the 'view' action. This can be overridden:-

	class MyModel extends AppModel {

		public $actsAs = array(
			'Navigation.Navigatable' => array(
				'action' => 'display'
			)
		);

	}

In your model you can define a parent menu (Model::parentMenu) that any content will be put under.

---

##Using the Navigation Helper with Twitter Bootstrap

This code snippet shows a basic working example of how to configure the Navigation Helper within your view to work with native Twitter Bootstrap mark-up and classes.

    <?php
	     echo $this->Navigation->menu($primary_nav, array(
			    'class' => 'nav navbar-nav',
			    'id' => 'primary-nav',
			    'tag' => 'li',
			    'wrapTag' => 'ul',
			    'wrapClass' => 'dropdown-menu',
			    'childWrapTag' => false,
			    'childrenClass' => 'dropdown',
			    'activeClass' => 'active',
			    'activeTrailClass' => 'menu-item--active-trail',
			    'itemClassPrefix' => 'menu-item--',
			    'model' => 'Menu',
			    'childrenImageClass' => 'menu-item--has-children-image',
			    'childrenLinkAttr' => array(
				    'class' => 'dropdown-toggle',
				    'data-toggle' => 'dropdown',
				    'role' => 'button',
				    'aria-haspopup' => 'true',
				    'aria-expanded' => 'false'
	       		)
	      )
     );
    ?>