<?php
/**
 * Menu controller for the Navigation plugin.
 *
 * @author  Andy Carter
 * @package Navigation
 */
App::uses('NavigationAppController', 'Navigation.Controller');

class MenusController extends NavigationAppController {

	public function __construct($request = null, $response = null) {
		parent::__construct($request, $response);

		$this->adminActions[] = 'admin_move_up';
		$this->adminActions[] = 'admin_move_down';
	}

/**
 * Prepare data for populating admin dropdowns.
 *
 * @return void
 */
	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();

		$this->set(
			'parents',
			$this->Menu->generateTreeList(
				null,
				null,
				null,
				'--'
			)
		);

		$this->set(
			'userGroups',
			$this->Menu->UserGroup->find(
				'list',
				array('order' => array('UserGroup.id' => 'ASC'))
			)
		);

		return;
	}

/**
 * Prepare the admin form fields for the menu item form
 * @return array
 */
	protected function _adminFormFields() {
		$Model = $this->{$this->modelClass};

		$fields = parent::_adminFormFields();

		$fields[$Model->alias . '.url']['label'] = 'URL';

		$fields[$Model->alias . '.new_window']['label'] = 'Open Link in New Window';

		unset($fields[$Model->alias . '.model']);
		unset($fields[$Model->alias . '.action']);
		unset($fields[$Model->alias . '.model_id']);
		unset($fields[$Model->alias . '.plugin']);
		unset($fields[$Model->alias . '.controller']);

		return $fields;
	}

/**
 * Menus admin listings page.
 * @return void
 */
	public function admin_index() {
		$Model = $this->{$this->modelClass}->alias;

		$this->set('toolbar', $this->_adminIndexToolbar());

		$data = $this->{$this->modelClass}->generateTreeList(null, null, null, '--');
		$this->set('data', $data);

		$this->set('title_for_layout', InflectorExt::pluralize($this->$Model->displayName));

		$this->view = 'Navigation.Menus/admin_index';

		return;
	}

/**
 * Menu item edit page.
 * @param int $id menu item ID
 */
	public function admin_edit($id = null) {
		parent::admin_edit($id);

		// If we're dealing with a menu item associated to another model
		// then we want to remove the URL field from the form. We need
		// to do this directly as the view variables have already been
		// set.
		if (!empty($this->request->data['Menu']['model'])) {

			unset($this->viewVars['fields']['url']);

		}

		// Can't add to self.
		// @TODO filter out children of self.
		unset($this->viewVars['parents'][$id]);

		return;
	}

	public function admin_move_up($id, $delta = 1) {
		if ($delta > 0) {

			if ($this->Menu->moveUp($id, abs($delta))) {

				$this->Session->setFlash(array(
					'title' => 'Item moved',
					'description' => ''
				), 'flash_success');

			} else {

				$this->Session->setFlash(array(
					'title' => 'Move failed',
					'description' => 'Failed to move menu item!'
				), 'flash_fail');

			}

		}

		$this->redirect(array('action' => 'index'));

		return;
	}

	public function admin_move_down($id, $delta = 1) {
		if ($delta > 0) {

			if ($this->Menu->moveDown($id, abs($delta))) {

				$this->Session->setFlash(array(
					'title' => 'Item moved',
					'description' => ''
				), 'flash_success');

			} else {

				$this->Session->setFlash(array(
					'title' => 'Move failed',
					'description' => 'Failed to move menu item!'
				), 'flash_fail');

			}

		}

		$this->redirect(array('action' => 'index'));

		return;
	}

}
