# EvMigrationUtil

## Introduction

A helper library to help manage data creation in migrations. E.g. creating pages and templates to go with your new feature

## Setup

Not much setup required

	composer require evoluted/migration-util

## Using the Utility

Out the box the migration utily comes with a copy of basic functions. To initial for a model use the following:

	$PageMigrationUtil = MigrationUtil::init('EvCore.Page');

You can then call methods like:

### createOnce()

```
	$PageMigrationUtil->createOnce(
		[
			'internal_title' => 'venue_index'
		],
		[
			'title' => 'All Venues',
			'internal_title' => 'venue_index',
			'body' => '....',
			...
		]
	);
```

This helper method will only create the record if it doesn't already exist

### createAllOnce()

```
	$PageMigrationUtil->createAllOnce(
		[
			'internal_title'
		],
		[
			[
				'title' => 'All Venues',
				'internal_title' => 'venue_index',
				'body' => '....',
				...
			],
		]
	);
```

This helper method will attempt to create multiple records as long as they don't exist. If a record doesn't exist then it doesn't interrupt the creation of the other records.

### updateSingle()

```
	$PageMigrationUtil->updateSingle(
		[
			'internal_title' => 'venue_index'
		],
		[
			'title' => 'All Venues',
			'internal_title' => 'venue_index',
			'body' => '....',
			...
		]
	);
```

This helper method will update an existing record. If it doesn't already exist then it will not be created.

### updateMultiple()

```
	$PageMigrationUtil->createAllOnce(
		[
			'internal_title'
		],
		[
			[
				'title' => 'All Venues',
				'internal_title' => 'venue_index',
				'body' => '....',
				...
			],
		]
	);
```

This helper method will update multiple records. If a record doesn't exist then it will not be created and will not interrupt the other updates.

### deleteIfExists()

```
	$PageMigrationUtil->deleteIfExists(
		[
			'internal_title' => 'venue_index',
		]
	);
```

This helper method will delete a single record. It will delete the first record that matches the conditions. Nothing is deleted if a record isn't found.

### deleteAll()

```
	$PageMigrationUtil->deleteIfExists(
		[
			'is_active' => false,
		]
	);
```

This helper method will delete multiple records. It acts as a wrapper for the cake model method deleteAll().

## Custom Model Migration Utilities

In the cases of complex plugins you may want to create a helper with more specific helper methods. In this case you want to create a class like this

	<?php

	App::uses('BaseMigrationModelUtil', 'EvMigrationUtil.Lib');

	class PageMigrationModelUtil extends BaseMigrationModelUtil {

	/**
	 * YOUR CUSTOM HELPERS HERE
	 * /
		public function createByInternalTitle($internalTitle....) {
			...
		}

For Plugin model save in

	[PLUGIN]/Lib/MigrationUtil/[Model]MigrationModelUtil.php

For App model save in

	app/Lib/MigrationUtil/[Model]MigrationModelUtil.php

For overriden plugin model

	app/Lib/MigrationUtil/[PluginName][Model]MigrationModelUtil.php

This still is initialised in the same way and it will find the overrides

	$PageMigrationUtil = new MigrationUtil('EvCore.Page');
