<?php
App::uses('BaseMigrationModelUtil', 'EvMigrationUtil.Lib');

/**
 * This is the main class of the Migration Utility, it is used to create model instances for the utilities
 */
class MigrationUtil {

/**
 * Gets an instance of a presenter for a given model
 *
 * @param string $model The plugin.model name.
 * @return BaseMigrationModelUtil Will return an instance of the MigationModelUtil or a Model override of
 */
	public static function init($model) {
		list($plugin, $modelAlias) = pluginSplit($model);

		// Check for an extended plugin presenter first. This will also find presenters for non-plugin models
		$migrationUtilClassName = $plugin . $modelAlias . 'MigrationModelUtil';
		App::uses($migrationUtilClassName, 'Lib/MigrationUtil');
		if (class_exists($migrationUtilClassName)) {
			return new $migrationUtilClassName($model);
		}

		//If an extended version couldn't be found check for a presenter in the plugin
		$migrationUtilClassName = $modelAlias . 'MigrationModelUtil';
		App::uses($migrationUtilClassName, $plugin . '.Lib/MigrationUtil');
		if (class_exists($migrationUtilClassName)) {
			return new $migrationUtilClassName($model);
		}

		// No override found use the base one
		return new BaseMigrationModelUtil($model);
	}

}
