$(document).ready(function(e) {

	$(document).on(
		'keyup',
		'#MetaDataTitle',
		function(e) {
			countCharacters('#MetaDataTitle', 55);

			buildPreview();
		}
	);

	$(document).on(
		'keyup',
		'#MetaDataDescription',
		function(e) {
			countCharacters('#MetaDataDescription', 200);
			buildPreview();
		}
	);

	countCharacters('#MetaDataTitle', 55);
	countCharacters('#MetaDataDescription', 200);
	buildPreview();

	if (advertUrl.length > 0) {
		$('#EvDisplay').load(advertUrl);
	}
});

/**
 * count the characters to show the limit for optimal SEO
 */
function countCharacters(inputId, limit) {
	if ($(inputId).length > 0) {
		var value = $(inputId).val();
		var count = value.length;

		if (typeof extra != 'undefined') {
			count += extra.length;
		}

		var counter = $(inputId).parents('.input').find('.charCounter');
		counter.children('.count').text(count);

		if (count > limit) {
			// count over the limit change to danger label
			counter.children('.count').addClass('label-danger');

			counter.children('.count').removeClass('label-success');
			counter.children('.count').removeClass('label-warning');
		} else if(count == limit || (limit - 5) < count) {
			// getting close to limit, show warning
			counter.children('.count').addClass('label-warning');

			counter.children('.count').removeClass('label-danger');
			counter.children('.count').removeClass('label-success');
		} else {
			// all okay
			counter.children('.count').addClass('label-success');

			counter.children('.count').removeClass('label-danger');
			counter.children('.count').removeClass('label-warning');
		}
	}
}

/**
 * rebuild the google preview
 * so they can see what it looks like
 */
function buildPreview() {
	var metaTitle = $('#MetaDataTitle').val();
	if (typeof metaTitle != 'undefined' && metaTitle.length == 0) {
		var metaTitle = $('#MetaDataTitle').attr('placeholder');
	}

	if (typeof metaTitle != 'undefined') {
		if (metaTitle.length > 60) {
			metaTitle = metaTitle.substr(0, 57) + '...';
		}
	}

	$('#google-preview').find('.metaTitle').text(metaTitle);

	// ----

	var metaDesc = $('#MetaDataDescription').val();
	if (metaDesc.length == 0) {
		var metaDesc = $('#MetaDataDescription').attr('placeholder');
	}

	if (typeof metaDesc != 'undefined') {
		if (metaDesc.length > 197) {
			metaDesc = metaDesc.substr(0, 197) + '...';
		}
	}

	$('#google-preview').find('.metaDesc').text(metaDesc);

	// ----
	if (typeof itemUrl != 'undefined') {
		if (itemUrl.length > 60) {
			var shortenAlias = itemAlias.substr(5);
			itemUrl = itemHost + '/ ... ' + shortenAlias;
		}

		$('#google-preview').find('.metaLink').text(itemUrl);
	}
}


