<?php

App::uses('AppHelper', 'View/Helper');

App::uses('MetaDataLib', 'MetaData.Lib');

class MetaHelper extends AppHelper {

	protected $_metaData = null;

/**
 * Default Constructor
 *
 * @param View $View The View this helper is being attached to.
 * @param array $settings Configuration settings for the helper.
 */
	public function __construct(View $View, $settings = []) {
		parent::__construct($View, $settings);

		if (!empty($settings['metaSettings'])) {
			if (!empty($settings['metaSettings']['libClass'])) {
				list($plugin, $class) = pluginSplit($settings['metaSettings']['libClass']);

				App::uses($class, (!empty($plugin) ? $plugin . '.' : '') . 'Lib');

				$this->_metaData = new $class(
					$settings['metaSettings'],
					isset($settings['model']) && is_object($settings['model']) ? $settings['model'] : null
				);
			}
		}
	}

/**
 * Call methods from MetaDataLib class.
 *
 * @param string $method Method to call.
 * @param array $params Parameters to pass to method.
 * @return mixed Whatever is returned by called method, or false on failure
 */
	public function __call($method, $params) {
		if (empty($this->_metaData)) {
			return false;
		}

		return call_user_func_array([$this->_metaData, $method], $params);
	}
}
