<?php

App::uses('MetaData', 'MetaData.Model');
App::uses('AppBehavior', 'Model/Behavior');

class MetaBehavior extends AppBehavior {

	public $settings = array();

	/**
	 * Initialise the behavior - store the settings against the model
	 *
	 * @see ModelBehavior::setup()
	 */
	public function setup(Model $Model, $settings = array()) {
		$this->settings[$Model->alias] = $settings;

		return;
	}

	/**
	 * Insert meta data into find results.
	 *
	 * @see ModelBehavior::afterFind()
	 */
	public function afterFind(Model $Model, $data, $primary = false) {
		if ($primary === true) {
			$MetaData = EvClassRegistry::init('MetaData.MetaData');

			$conditions = array();

			foreach ($data as $item) {

				if (isset($item[$Model->alias]) && ! empty($item[$Model->alias]['id'])) {

					$conditions[] = array(
						$MetaData->alias . '.model' => $Model->alias,
						$MetaData->alias . '.model_id' => $item[$Model->alias]['id']
					);
				}
			}

			if (! empty($conditions)) {

				$meta = $MetaData->find('all', array(
					'conditions' => array(
						'OR' => $conditions
					)
				));

				$meta = Hash::combine(
					$meta,
					'{n}.MetaData.model_id',
					'{n}',
					'{n}.MetaData.model'
				);

				foreach ($data as $key => $item) {

					if (! empty($item[$Model->alias]['id']) && ! empty($meta[$Model->alias][$item[$Model->alias]['id']]['MetaData'])) {

						$data[$key]['MetaData'] = $meta[$Model->alias][$item[$Model->alias]['id']]['MetaData'];
					}
				}
			}
		}

		return $data;
	}

	/**
	 * Prepare the data for saving.
	 *
	 * @see ModelBehavior::beforeSave()
	 */
	public function beforeSave(Model $Model, $options = array()) {
		if (isset($Model->data[$Model->alias]['MetaData'])) {

			$Model->data['MetaData'] = $Model->data[$Model->alias]['MetaData'];
			unset($Model->data[$Model->alias]['MetaData']);

		}

		return parent::beforeSave($Model, $options);
	}

	/**
	 * Save the meta data
	 *
	 * @see ModelBehavior::afterSave()
	 */
	public function afterSave(Model $Model, $created, $options = array()) {
		parent::afterSave($Model, $created, $options);

		if (empty($Model->data['MetaData'])) {
			return;
		}

		$Model->data['MetaData']['model'] = $Model->alias;
		$Model->data['MetaData']['model_id'] = $Model->id;

		$MetaData = EvClassRegistry::init('MetaData.MetaData');
		$MetaData->create();
		$MetaData->save($Model->data);

		return;
	}
}
