<?php

App::uses('AppComponent', 'Controller/Component');

App::uses('CakeText', 'Utility');
App::uses('InflectorExt', 'EvInflector.Lib');

class MetaComponent extends AppComponent {

	protected $_metaData = null;

/**
 * Default settings for this Component
 *
 * @var array
 */
	protected $_defaultSettings = [
		'titleField' => null, // The field from the model to use to set the meta title.
		'titleIncludesSiteTitle' => true, // Include the site title to the end of the meta title. Set to false to disable this.
		'descriptionField' => 'content', // The field from the model to use to set the meta description
		'descriptionLength' => 200, // The length of the meta description when using model fields
		'libClass' => 'MetaData.MetaDataLib', //The meta lib file to get the title/description/keywords from. Modify for custom behavior.
		'overrideModel' => null, //Define the model used to set the meta data form.
	];

/**
 * Calls parent. Merges default settings with any settings passed to the controller
 *
 * @param Controller $controller The controller loading this component.
 * @return void.
 * @see Component::initialize()
 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);

		$this->settings = array_merge($this->_defaultSettings, $this->settings);

		if (!empty($this->settings['libClass'])) {
			list($plugin, $class) = pluginSplit($this->settings['libClass']);

			App::uses($class, (!empty($plugin) ? $plugin . '.' : '') . 'Lib');

			$this->_metaData = new $class($this->settings);
		}

		$controller->toInject['components'][] = 'MetaData.Meta';
	}

/**
 * Sets the view variables for the meta data.
 *
 * @param array $data array containing the MetaData
 * @param string $overrideModel The main model, useful if setting Page content from within a plugin
 * @return void.
 */
	public function set($data, $overrideModel = null) {
		$Model = $this->_controller->{$this->_controller->modelClass};

		// override the Model, otherwise plugins will look at their own models
		// for the title when it may actually want to look at 'Page' Model.
		if (!empty($overrideModel)) {
			$this->_controller->loadModel($overrideModel);
			list($pluginName, $modelName) = pluginSplit($overrideModel);
			$Model = $this->_controller->{$modelName};
		} elseif (!empty($this->settings['overrideModel'])) {
			$this->_controller->loadModel($this->settings['overrideModel']);
			list($pluginName, $modelName) = pluginSplit($this->settings['overrideModel']);
			$Model = $this->_controller->{$modelName};
		}

		// Set the title for layout, either using the meta title, display
		// field, or model name.
		$title = $this->_getTitleForLayout($data, $Model);

		$description = $this->_getDescriptionForLayout($data, $Model);

		$keywords = $this->_getKeywordsForLayout($data, $Model);

		$this->_controller->set('titleForLayout', $title);

		// Set title_for_layout for backwards compatibility (CakePhp 2.4.x).
		$this->_controller->set('title_for_layout', $title);

		$this->_controller->set('metaTitle', $title);
		$this->_controller->set('metaDescription', $description);
		$this->_controller->set('metaKeywords', $keywords);
	}

/**
 * Set the title for layout, either using the meta title, display field, or model name.
 *
 * @param array $data  The data passed through from the controller.
 * @param obj   $Model The model to check available fields.
 * @return string The meta title to set.
 */
	protected function _getTitleForLayout($data, $Model) {
		if (empty($this->_metaData) || !is_object($this->_metaData)) {
			return '';
		}

		return $this->_metaData->getTitleForLayout($data, $Model);
	}

/**
 * Set the description for layout, either using the meta description, overriden description field, body or description
 * field.
 *
 * @param array $data  The data passed through from the controller.
 * @param obj   $Model The model to check available fields.
 * @return string The meta description to set.
 */
	protected function _getDescriptionForLayout($data, $Model) {
		if (empty($this->_metaData) || !is_object($this->_metaData)) {
			return '';
		}

		return $this->_metaData->getDescriptionForLayout($data, $Model);
	}

/**
 * Set the description for layout, using the meta keywords or null.
 *
 * @param array $data  The data passed through from the controller.
 * @param obj   $Model The model to check available fields.
 * @return string The meta keywords to set.
 */
	protected function _getKeywordsForLayout($data, $Model) {
		if (empty($this->_metaData) || !is_object($this->_metaData)) {
			return '';
		}

		return $this->_metaData->getDescriptionForLayout($data, $Model);
	}

/**
 * Inject data/content into the admin form.
 *
 * @param array $data  Current request data
 * @param obj   $Model The model currently being modified.
 * @param int   $id    The if of the model record being modified. Null if no id is present.
 * @return void.
 */
	public function injectAdminForm($data, $Model, $id) {
		if (!empty($this->settings['overrideModel'])) {
			$this->_controller->loadModel($this->settings['overrideModel']);
			list($pluginName, $modelName) = pluginSplit($this->settings['overrideModel']);
			$Model = $this->_controller->{$modelName};
		}

		$this->_controller->helpers['MetaData.Meta'] = [
			'model' => $Model,
			'metaSettings' => $this->settings,
		];
	}
}
