<?php

App::uses('MediaLibraryAppModel', 'EvMediaLibrary.Model');

class MediaLibraryFile extends MediaLibraryAppModel {

	public $displayField = 'location';

	public $documentSlots = [
		'Main' => array(
			'slots' => 1,
			'validate' => array(
				'filename' => array(
					'extension' => array(
						'rule' => array('extension', array('jpg', 'jpeg', 'png', 'txt', 'pdf', 'doc', 'docx')),
						'message' => 'File extension now allowed'
					)
				)
			)
		)
	];

/**
 * Finishes off the location field by appending the file name to it
 *
 * @param array $results Results of the find
 * @param bool $primary Is Primary
 * @return array           Results
 */
	public function afterFind($results, $primary = false) {
		$results = parent::afterFind($results, $primary);

		foreach ($results as &$result) {
			if (!empty($result['MainDocument'])) {

				// Not a vritual field as it is not contained on every find
				$result['MediaLibraryFile']['location'] =
				Configure::read('App.fullBaseUrl') . '/files/document' .
				'/' . $result['MainDocument'][0]['id'] .
				'/' . $result['MainDocument'][0]['filename'];
			}
		}

		return $results;
	}
}
