<?php

App::uses('MediaLibraryAppController', 'EvMediaLibrary.Controller');

class MediaLibraryFilesController extends MediaLibraryAppController {

/**
 * Defines the columns displayed in the admin_index results table
 * using a columns whitelist.
 *
 * @return Array
 */
	protected function _adminIndexColumns() {
		$cols = parent::_adminIndexColumns();

		$extraCols = [
			'MediaLibraryFile.thumbanil' => [
				'type' => 'Image',
				'label' => 'Thumbnail',
				'element' => 'EvMediaLibrary.thumbnail'
			]
		];

		$cols = ArrayUtil::addAfter($cols, 'key', $extraCols);

		// Can remove this line, just wanted the extra space so we could have a bigger thumbnail
		unset($cols['MediaLibraryFile.id']);
		unset($cols['MediaLibraryFile.is_active']);

		return $cols;
	}

/**
 * Defines the fields displayed in an admin_form for this model
 *
 * @return Array Fields to be shown in admin edit forms
 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['MediaLibraryFile.location']['disabled'] = true;

		return $fields;
	}

/**
 * Pagination settings for admin_index
 *
 * Override in your own controller to customise
 *
 * @return array
 */
	protected function _adminIndexPaginate() {
		$settings = parent::_adminIndexPaginate();

		$settings['contain'][] = 'MainDocument';

		return $settings;
	}
}
