<h1 class='title'>Manual Payment <span>Administration</span></h1>
<div class="row">
	<div class="col-xs-12 col-sm-6 col-md-4">
		<h2 class="float--left results_wrapper__title">Pending Manual Payments</h2>
	</div>
	<div class="col-xs-12 col-sm-6 col-md-8">
	<?php
		echo $this->Element('toolbar', array(
			'links'=>array(
				'View All'=>array('action'=>'index')
			)
		));

		echo $this->Html->tag('span', $this->Paginator->counter('Total pending payments: {:count}'), array('class' => 'float--right toolbar'));

		echo $this->Form->create('Transaction', ['class' => 'float--right toolbar form-inline col-xs-6']);
		echo $this->Form->input(
			$primaryModel . '.results_per_page',
			array(
				'type' => 'select',
				'options' => array(
					10 => 10,
					20 => 20,
					50 => 50,
					100 => 100
				),
				'label' => array(
					'text' => 'Results per page',
					'class' => 'control-label col-xs-6'
				),
				'wrapInput' => 'col-xs-6',
				'class' => 'form-control col-xs-12',
				'div' => 'spoken-form form-group col-xs-12',
				'onchange' => 'this.form.submit()'
			)
		);
		echo $this->Form->end();
	?>
	</div>
</div>
<div class="row">
	<div class="col-xs-12">
	<?php echo $this->Form->create('Transaction', array('class' => 'results')); ?>
	<table>
		<tr>
			<?php
				$sortKey = $this->Paginator->sortKey($primaryModel);
				$sortDir = $this->Paginator->sortDir($primaryModel);

				if (!empty($multiEditActions)):
					echo $this->Html->tag(
						'th',
						'&nbsp;'
					);
				endif;

				foreach ($columns as $field=>$attr):

					if ($attr['type'] !== 'hidden'):

						$class = $field==$sortKey ? "class='sort sort--$sortDir'" : '';

						echo "<th $class>" . $this->Paginator->sort($field, $attr['label']) . "</th>";

					endif;

				endforeach;

			?>
			<?php foreach($actions as $type => $action): ?>
			<th class='action'><?php echo $type; ?></th>
			<?php endforeach; ?>
		</tr>
		<?php
			foreach ($data as $id=>$item):

				echo $this->Html->tag('tr', null, array('class' => ($id % 2 == 0 ? "odd" : "even")));

				if (!empty($multiEditActions)):

					echo $this->Html->tag(
						'td',
						$this->Form->checkbox($primaryModel . '.id.' . $item[$primaryModel][$primaryKey]),
						array(
							'class' => 'multi-edit'
						)
					);
				endif;

				foreach ($columns as $field=>$attr):

					if ($attr['type'] != 'hidden'):

						echo $this->Html->tag('td', $this->Listing->nice($field, $attr, $item), array('class' => $attr['type']));

					endif;

				endforeach;


				foreach ($actions as $type => $action):

					echo $this->Html->tag(
						'td',
						null,
						(! empty($action['cell'])) ? $action['cell'] : array()
					);

					if (! empty($action['helper']) && method_exists($this->Listing, $action['helper'])):

						echo $this->Listing->{$action['helper']}(
							$action,
							$item,
							array(
								'name' => $primaryModel,
								'key' => $primaryKey
							)
						);

					else:

						$url = $action['link']['url'];

						if (is_array($url)) {

							$url[] = $item[$primaryModel][$primaryKey];
						}

						echo $this->Html->link(
							$action['link']['text'],
							$url,
							$action['link']['options']
						);

					endif;

					echo $this->Html->tag('/td');

				endforeach;


				echo "</tr>";

			endforeach;
		?>
	</table>
	</div>
</div>

<div class="row">
	<div class="col-xs-12">

	<?php
		if (!empty($multiEditActions)):

			echo $this->Form->hidden('Form.process', ['value' => 'multiedit']);
			echo $this->Form->select(
				'multiedit',
				$multiEditActions,
				array('onchange' => 'this.form.submit()', 'empty' => 'With selected...')
			);

		endif;

		echo $this->Form->end();
	?>
	</div>
</div>

<?=$this->Element('index_paginate')?>
