<?php

App::uses('GatewayBaseComponent', 'EvTransactions.Controller/Component');
App::uses('GatewayInterface', 'EvTransactions.Lib');
App::uses('CakeText', 'Utility');

class ManualPaymentComponent extends GatewayBaseComponent implements GatewayInterface {

	protected $_objects = array();

	protected $_transactionId;

/**
 * Use the function setup and connection / settings that need setting up in the gateway
 *
 * @return void.
 */
	public function setup() {
		return null;
	}

/**
 * Use this function setup the actual payment, i.e. setup the basket, the amount to take etc...
 *
 * @param int $transactionId Transaction id we have created
 * @param array $return - array with 2 keys of 'return', 'cancel'. Containing either a link or router array for redirecting user
 * @param array $model - array with two keys of 'model' and 'model_id', used to link transactions polymorphically to other model items
 * @param float|array $amount - amount of monies to take (I GOT YOUR MONIESSSSSS), or array of 'amount' and 'currency' to change currencies (will take default from config)
 * @param array $items - multidimenisional array break down of the transaction items, required elements are 'description' and 'amount'
 * @param mixed $extra - variable allowing you to pass ay data needed to the gateway, could be things like addresses that are not tracked by the transactions model
 * @return bool True to continue payment.
 */
	public function setupPayment($transactionId, $return, $model, $amount, $items, $extra = array()) {
		return true;
	}

/**
 * Everything should be setup, actually take the payment. As the payment is manual, the status isn't updated and the
 * redirect needs to be overridden to go to the manual payment complete action to finish the payment.
 *
 * @param int $transactionId transactions id
 * @return mixed dependent on the gateway, value is return straight from the transaction component to user anyway
 */
	public function getPayment($transactionId) {
		$this->Transaction = EvClassRegistry::init('EvTransactions.Transaction');

		$this->Transaction->id = $transactionId;
		$this->Transaction->save(array(
			'Transaction' => array(
				'message' => 'Offline payment - awaiting manual confirmation of payment'
			)
		));

		return $this->_controller->redirect(
			[
				'admin' => false,
				'plugin' => 'ev_manual_payment',
				'controller' => 'manual_payment',
				'action' => 'complete',
				'?' => [
					'transaction' => $transactionId,
				],
			]
		);
	}

/**
 * Deal with a return from the gateway and check for success / fail
 *
 * @return array - with three elements,
 *               - 'result' = true/false value
 *               - 'message' = text message about transaction (i.e. reason for failing)
 *               - 'transaction_id' = int of the transaction row
 */
	public function processReturn() {
		return [
			'result' => true,
		];
	}
}
