<?php
App::uses('PluginInstallShell', 'shells');

class EvManualPaymentInstallShell extends PluginInstallShell {

	public $uses = array(
		'EvSiteSettings.SiteSetting',
		'EvSiteSettings.SiteSettingCategory'
	);

	/**
	 * call parent run() This will auto run any migrations
	 *
	 * Use the run() method here to insert any content
	 */
	public function run() {
		parent::run();

		$Category = $this->SiteSettingCategory->save(
			array(
				'SiteSettingCategory' => array(
					'name' => 'Manual Payments',
					'array_slug' => 'manual_payment',
					'sequence' => 0,
					'prevent_edit' => 1
				)
			)
		);

		$this->SiteSetting->save(
			array(
				'SiteSetting' => array(
					'name' => 'Payment Instructions',
					'array_slug' => 'payment_instructions',
					'type' => 'html',
					'sequence' => 0,
					'site_setting_category_id' => $this->SiteSettingCategory->id,
					'prevent_edit' => 1
				)
			)
		);
	}

}
