<?php
App::uses('EvLoyaltyPointsAppModel', 'EvLoyaltyPoints.Model');
/**
 * EvLoyaltyPointsPointValue Model
 *
 * @property Currency $Currency
 */
class PointValue extends EvLoyaltyPointsAppModel {

/**
 * Use table
 *
 * @var mixed False or table name
 */
	public $useTable = 'point_value';

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'currency_id';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'currency_id' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

	// The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'Currency' => array(
			'className' => 'EvCurrency.Currency',
			'foreignKey' => 'currency_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);


	public function beforeFind($query) {

		$query['contain'][] = 'Currency';

		return $query;

	}
}
