<?php
App::uses('EvLoyaltyPointsAppModel', 'EvLoyaltyPoints.Model');
/**
 * Point Model
 *
 * @property User $User
 */
class Point extends EvLoyaltyPointsAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'user_id';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'user_id' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
		'points' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		),
	);

	// The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'User' => array(
			'className' => 'User',
			'foreignKey' => 'user_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

	public function totalPoints($userId) {
		$allPoints = $this->find('all', array(
			'conditions' => array(
				'user_id' => $userId
			)
		));

		$totalPoints = 0;

		foreach ($allPoints as $point) {

			if ($point['Point']['is_debit'] == '1') {
				$totalPoints = $totalPoints - $point['Point']['points'];
			} else {
				$totalPoints = $totalPoints + $point['Point']['points'];
			}
		}

		return floor($totalPoints);
	}

	public function deductPoints($userId, $points, $model = null, $modelId = 0, $description = null) {
		$data = array(
			'model' => $model,
			'model_id' => $modelId,
			'user_id' => $userId,
			'points' => floor($points),
			'description' => $description,
			'is_debit' => 1
		);

		return $this->save($data);
	}
}
