<?php

class PointLib {

	/**
	 * calculate the discount based on how many points the user has
	 *
	 * @param 	array 	$codeData 	The code data we are calculating
	 * @param 	float 	$subtotal 	The subtotal amount to calculate percentages off
	 * @return 	float 	$amount 	The discount amount
	 */
	public static function calculate($subtotal, $model, $modelId = 0, $totalPoints = 0) {
		$userId = CakeSession::read('Auth.User.User.id');

		if ($userId <= 0) {
			return 0;
		}

		$amount = 0;

		// If the points param is provided, use that as our total points to apply, otherwise just use
		// all the users available points.
		if ($totalPoints <= 0) {
			$pointModel = EvClassRegistry::init('EvLoyaltyPoints.Point');
			$totalPoints = $pointModel->totalPoints($userId);
		}

		if ($totalPoints > 0) {
			// Load the details for the current currency
			$pointValueModel = EvClassRegistry::init('EvLoyaltyPoints.PointValue');

			$pointValue = $pointValueModel->find('first', array(
				'conditions' => array(
					'currency_id' => CakeSession::read('EvCurrency.currencyId')
				)
			));

			if (! empty($pointValue)) {
				if ($pointValue['PointValue']['minimum_spend'] > $subtotal) {
					return 0;
				}

				// Work out maximum points that can be applied to this order.

				$basicSubTotal = $subtotal;

				if (Configure::read('EvLoyaltyPoints.roundDown')) {
					$basicSubTotal = floor($subtotal);
				}
				$maxPoints = $basicSubTotal * $pointValue['PointValue']['points_per_unit'];

				$points = 0;
				if ($totalPoints > $maxPoints) {
					// The user has more points than the maximum, so just apply the maximum.
					$amount = ($maxPoints / $pointValue['PointValue']['points_per_unit']);
					$points = $maxPoints;
				} else {
					$amount = ($totalPoints / $pointValue['PointValue']['points_per_unit']);
					$points = $totalPoints;
				}

				if ($amount > 0) {
					// Add a session so we can later add a deduction record into the points table
					CakeSession::write('EvLoyaltyPoints.pointsUsed', floor($points));
				}
			}
		}

		return $amount;
	}

	public function calculateEarntPoints($totalPaid, $currencyId) {
		$pointsEarnt = 0;

		$pointValueModel = EvClassRegistry::init('EvLoyaltyPoints.PointValue');

		$pointValue = $pointValueModel->find('first', array(
			'conditions' => array(
				'currency_id' => $currencyId
			)
		));

		if (! empty($pointValue)) {
			if (Configure::read('EvLoyaltyPoints.roundDown')) {
				$totalPaid = floor($totalPaid);
			}
			$pointsEarnt = $pointValue['PointValue']['points_earnt_per_unit'] * $totalPaid;
		}

		return $pointsEarnt;
	}

	public function calculatePointsFromCurrency($amount, $currencyId) {
		$pointValueModel = EvClassRegistry::init('EvLoyaltyPoints.PointValue');

		$pointValue = $pointValueModel->find('first', array(
			'conditions' => array(
				'currency_id' => $currencyId
			)
		));

		if (! empty($pointValue)) {
			if (Configure::read('EvLoyaltyPoints.roundDown')) {
				$totalPaid = floor($totalPaid);
			}
			$pointsEarnt = $amount * $pointValue['PointValue']['points_per_unit'];
		}

		return $pointsEarnt;

	}
}
