<?php

App::uses('CakeEventListener', 'Event');
App::uses('PointLib', 'EvLoyaltyPoints.Lib');

class EvLoyaltyPointsApplyPointListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvCheckout.Component.Order.paid' => array(
				'callable' => 'applyPoints',
				'priority' => 100
			)
		);
	}

	public function applyPoints(CakeEvent $Event) {
		// 'orderId' should be set in data
		if (empty($Event->data['orderId'])) {
			return false;
		}

		$Order = EvClassRegistry::init('EvCheckout.Order');
		$details = $Order->readForEdit($Event->data['orderId']);

		// Get points used
		$pointsUsed = CakeSession::read('EvLoyaltyPoints.pointsUsed');
		$userId = CakeSession::read('Auth.User.User.id');

		$pointModel = EvClassRegistry::init('EvLoyaltyPoints.Point');

		if ($pointsUsed > 0) {

			// Add a record to the points table to deduct the used points from the users balance.
			$pointModel->deductPoints($userId, $pointsUsed, 'EvCheckout.Order', $Event->data['orderId'], 'Points used against order id ' . $Event->data['orderId']);

			CakeSession::delete('EvLoyaltyPoints');
			setcookie('EvBasket[basketHash]', null, null, '/');
		}

		// Issue loyalty points aginst the order
		$totalSpent = 0;

		if (isset($details['OrderItem']) && ! empty($details['OrderItem'])) {

			foreach ($details['OrderItem'] as $item) {
				$totalSpent += ($item['row_total'] + (($item['row_total'] / 100) * $item['tax_rate']));
			}

			$discount = 0;
			// Check for any discounts applied to the order
			foreach ($details['OrderTotal'] as $total) {
				if ($total['name'] == 'Discount') {
					$totalSpent += $total['amount'];
				}
			}
		}

		$pointLib = new PointLib();
		$pointsEarnt = $pointLib->calculateEarntPoints($totalSpent, $details['Order']['currency_id']);

		if ($pointsEarnt > 0 && $userId > 0) {
			$pointModel->clear();
			$pointModel->set(
				array(
					'user_id' => $userId,
					'model' => 'EvCheckout.Order',
					'model_id' => $Event->data['orderId'],
					'description' => 'Points earnt from order id ' . $Event->data['orderId'],
					'points' => $pointsEarnt
				)
			);
			$pointModel->save();
		}

		return true;
	}
}
