<?php
App::uses('EvLoyaltyPointsAppController', 'EvLoyaltyPoints.Controller');

class PointsController extends EvLoyaltyPointsAppController {

	public $uses = 'EvLoyaltyPoints.Point';

	public function index() {
		// Load user points record
		$points = $this->{$this->modelClass}->find('all', array(
			'conditions' => array(
				'user_id' => $this->Auth->user('User.id')
			)
		));
		$this->set('points', $points);

		$pageId = Configure::read('EvLoyaltyPoints.pageId');

        if (! empty($pageId)) {
        	$this->loadModel('EvCore.Page');
            $page = $this->Page->readForView($pageId);

            if (! empty($page)) {
                $this->Meta->set($page, 'Page');
                $this->set('page', $page);
            }
        }

		$this->Meta->set(
			array(
				'Page' => array(
					'title' => 'My Points'
				)
			),
			'EvCore.Page'
		);

		$this->view = 'EvLoyaltyPoints.LoyaltyPoints/index';
	}

	protected function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();

		unset ($columns['Point.user_id']);

		$extraColumns = array(
			'User.name' => array(
				'type' => 'text',
				'label' => 'User'
			),
			'User.id' => array(
				'type' => 'integer',
				'label' => 'User Id'
			),
			'Point.description' => array(
				'type' => 'text',
				'length' => '80',
				'label' => 'Description'
			),
			'Point.points' => array(
				'type' => 'integer',
				'label' => 'Points'
			),
			'Point.is_debit' => array(
				'type' => 'boolean',
				'label' => 'Debit'
			)
		);
		return ArrayUtil::addAfter(
			$columns,
			'Point.id',
			$extraColumns
		);
	}

	protected function _adminIndexPaginate() {
		$paginate = parent::_adminIndexPaginate();

		$paginate['contain'][] = 'User';

		return $paginate;
	}

}
