<?php
App::uses('EvLoyaltyPointsAppController', 'EvLoyaltyPoints.Controller');
App::uses('ArrayUtil', 'EvCore.Lib');

class PointValuesController extends EvLoyaltyPointsAppController {

	public $uses = 'EvLoyaltyPoints.PointValue';

	public function _adminIndexColumns() {
		$columns = parent::_adminIndexColumns();

		unset($columns['PointValue.currency_id']);

		$extraColumns['Currency.name'] = array(
			'label' => 'Currency',
			'type' => 'text'
		);

		$extraColumns['PointValue.points_per_unit'] = array(
			'label' => 'Points per Unit',
			'type' => 'numeric'
		);

		$columns = ArrayUtil::addAfter(
			$columns,
			'PointValue.id',
			$extraColumns
		);

		return $columns;
	}

	protected function _adminIndexPaginate() {
		$paginate = parent::_adminIndexPaginate();

		$paginate['contain'][] = 'Currency';

		return $paginate;
	}

	public function _adminFormFields() {
		$fields = parent::_adminFormFields();
		$fields['PointValue.minimum_spend']['type'] = 'integer';

		return $fields;
	}

}
