<?php
App::uses('AppComponent', 'Controller/Component');
App::uses('PointLib', 'EvLoyaltyPoints.Lib');

class LoyaltyPointsComponent extends AppComponent {

	/**
	 * Component startup - check for the form being submitted
	 *
	 */
	public function startup(Controller $Controller) {
		if ($this->_controller->request->is('post') && isset($this->_controller->request->data['ApplyLoyaltyPoints']) &&
			(! empty($this->_controller->request->data['ApplyLoyaltyPoints']) || (
				isset($this->_controller->request->data['LoyaltyPoints']) && $this->_controller->request->data['LoyaltyPoints'] > 0))) {

			if (Configure::read('EvLoyaltyPoints.enterAsMonetaryValue')) {
				// The system is set to accept a post value that is a monetary value
				$currencyId = CakeSession::read('EvCurrency.currencyId');

				// Convert the monetary value provided back to points.
				$this->_controller->request->data['LoyaltyPoints'] = PointLib::calculatePointsFromCurrency($this->_controller->request->data['LoyaltyPoints'], $currencyId);
			}

			$this->_setupCookie();
			$loyaltyPointCookie = $this->_controller->LoyaltyPointsCookie->read('LoyaltyPoints');

			if (! empty($loyaltyPointCookie)) {
				$this->_controller->Flash->fail(
					__('Your loyalty point balance has already been applied'),
					array(
						'key' => 'loyalty-points-flash'
					)
				);

				return false;
			}

			$pointModel = EvClassRegistry::init('EvLoyaltyPoints.Point');
			$totalPoints = $pointModel->totalPoints($this->_controller->Auth->user('User.id'));

			if (empty($totalPoints)) {
				$this->_controller->Flash->fail(
					__('You don\'t currently have any loyalty points to apply to your order.'),
					array(
						'key' => 'discount-flash'
					)
				);

				return false;
			}

			CakeSession::write('EvLoyaltyPoints.LoyaltyPoints', true);

			$pointsToUse = 0;
			// The user has specified that they want to only use a set number of their points. Do some checks to make
			// sure they arent trying to use more points than they have first though.

			if ($this->_controller->request->data['LoyaltyPoints'] <= $totalPoints) {
				$pointsToUse = $this->_controller->request->data['LoyaltyPoints'];
			}

			// dispatch event
			$this->_controller->getEventManager()->dispatch(
				new CakeEvent('EvLoyaltyPoints.Component.Points.usePoints', $this, array(
					'pointsToUse' => $pointsToUse
				))
			);

			if ($pointsToUse > 0) {
				CakeSession::write('EvLoyaltyPoints.discountApplied', true);
				$this->_controller->Flash->success(
					__('Your loyalty point balance has been appied to your order.'),
					array(
						'key' => 'discount-flash'
					)
				);
			} else {
				CakeSession::write('EvLoyaltyPoints.discountApplied', false);
				$this->_controller->Flash->fail(
					__('You don\'t currently have enough loyalty points to apply the requested discount.'),
					array(
						'key' => 'discount-flashh'
					)
				);
			}
		}
		return true;
	}

	/**
	 * setup the loyalty code cookie
	 */
	protected function _setupCookie() {
		if (empty($this->_controller->LoyaltyPointsCookie)) {
			$this->_controller->LoyaltyPointsCookie = $this->_controller->loadComponent('EvLoyaltyPoints.LoyaltyPointsCookie');
		}
	}
}
